/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DownloadManagerHelper {
    private static final Pattern IGNORED_PROTOCOL_PATTERN = Pattern.compile("^(jar|war|war-i|warref|webbundle|wrap|spring|blueprint):.*$");

    private DownloadManagerHelper() {
    }

    public static String stripUrl(String url) {
        String strippedUrl = url;
        Matcher matcher = IGNORED_PROTOCOL_PATTERN.matcher(strippedUrl);
        while (matcher.matches()) {
            String protocol = matcher.group(1);
            strippedUrl = strippedUrl.substring(protocol.length() + 1);
            matcher = IGNORED_PROTOCOL_PATTERN.matcher(strippedUrl);
        }
        if (strippedUrl.contains("?")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(63));
        }
        if (strippedUrl.contains("$")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(36));
        }
        if (strippedUrl.contains("#")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(35));
        }
        return strippedUrl;
    }

    public static String stripInlinedMavenRepositoryUrl(String url) {
        if (url.startsWith("mvn:") && url.contains("!")) {
            return url.substring(4, url.indexOf(33));
        }
        return null;
    }

    public static String removeInlinedMavenRepositoryUrl(String url) {
        if (url.startsWith("mvn:") && url.contains("!")) {
            return "mvn:" + url.substring(url.indexOf(33) + 1);
        }
        return url;
    }
}

