/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.util.graph.visitor;

import shaded.org.eclipse.aether.graph.DependencyFilter;
import shaded.org.eclipse.aether.graph.DependencyNode;
import shaded.org.eclipse.aether.graph.DependencyVisitor;
import shaded.org.eclipse.aether.util.graph.visitor.Stack;

public final class FilteringDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final DependencyVisitor visitor;
    private final Stack<Boolean> accepts;
    private final Stack<DependencyNode> parents;

    public FilteringDependencyVisitor(DependencyVisitor visitor, DependencyFilter filter) {
        if (visitor == null) {
            throw new IllegalArgumentException("dependency visitor not specified");
        }
        this.visitor = visitor;
        this.filter = filter;
        this.accepts = new Stack();
        this.parents = new Stack();
    }

    public DependencyVisitor getVisitor() {
        return this.visitor;
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean accept = this.filter == null || this.filter.accept(node, this.parents);
        this.accepts.push(accept);
        this.parents.push(node);
        if (accept) {
            return this.visitor.visitEnter(node);
        }
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        this.parents.pop();
        Boolean accept = this.accepts.pop();
        if (accept.booleanValue()) {
            return this.visitor.visitLeave(node);
        }
        return true;
    }
}

