/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.RolloverDescriptionImpl;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.rolling.helper.ActionBase;
import org.apache.log4j.rolling.helper.FileRenameAction;
import org.apache.log4j.rolling.helper.GZCompressAction;
import org.apache.log4j.rolling.helper.ZipCompressAction;

public final class FixedWindowRollingPolicy
extends RollingPolicyBase {
    private static final int MAX_WINDOW_SIZE = 12;
    private int maxIndex = 7;
    private int minIndex = 1;
    private boolean explicitActiveFile;

    @Override
    public void activateOptions() {
        PatternConverter itc;
        super.activateOptions();
        if (this.maxIndex < this.minIndex) {
            LogLog.warn("MaxIndex (" + this.maxIndex + ") cannot be smaller than MinIndex (" + this.minIndex + ").");
            LogLog.warn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        if (this.maxIndex - this.minIndex > 12) {
            LogLog.warn("Large window sizes are not allowed.");
            this.maxIndex = this.minIndex + 12;
            LogLog.warn("MaxIndex reduced to " + String.valueOf(this.maxIndex) + ".");
        }
        if ((itc = this.getIntegerPatternConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.getFileNamePattern() + "] does not contain a valid integer format specifier");
        }
    }

    @Override
    public RolloverDescription initialize(String file, boolean append) {
        String newActiveFile = file;
        this.explicitActiveFile = false;
        if (this.activeFileName != null) {
            this.explicitActiveFile = true;
            newActiveFile = this.activeFileName;
        }
        if (file != null) {
            this.explicitActiveFile = true;
            newActiveFile = file;
        }
        if (!this.explicitActiveFile) {
            StringBuffer buf = new StringBuffer();
            this.formatFileName(new Integer(this.minIndex), buf);
            newActiveFile = buf.toString();
        }
        return new RolloverDescriptionImpl(newActiveFile, append, null, null);
    }

    @Override
    public RolloverDescription rollover(String currentFileName) {
        if (this.maxIndex >= 0) {
            String renameTo;
            int purgeStart = this.minIndex;
            if (!this.explicitActiveFile) {
                ++purgeStart;
            }
            if (!this.purge(purgeStart, this.maxIndex)) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            this.formatFileName(new Integer(purgeStart), buf);
            String compressedName = renameTo = buf.toString();
            ActionBase compressAction = null;
            if (renameTo.endsWith(".gz")) {
                renameTo = renameTo.substring(0, renameTo.length() - 3);
                compressAction = new GZCompressAction(new File(renameTo), new File(compressedName), true);
            } else if (renameTo.endsWith(".zip")) {
                renameTo = renameTo.substring(0, renameTo.length() - 4);
                compressAction = new ZipCompressAction(new File(renameTo), new File(compressedName), true);
            }
            FileRenameAction renameAction = new FileRenameAction(new File(currentFileName), new File(renameTo), false);
            return new RolloverDescriptionImpl(currentFileName, false, renameAction, compressAction);
        }
        return null;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    private boolean purge(int lowIndex, int highIndex) {
        int i;
        int suffixLength = 0;
        ArrayList<FileRenameAction> renames = new ArrayList<FileRenameAction>();
        StringBuffer buf = new StringBuffer();
        this.formatFileName(new Integer(lowIndex), buf);
        String lowFilename = buf.toString();
        if (lowFilename.endsWith(".gz")) {
            suffixLength = 3;
        } else if (lowFilename.endsWith(".zip")) {
            suffixLength = 4;
        }
        for (i = lowIndex; i <= highIndex; ++i) {
            String highFilename;
            File toRename = new File(lowFilename);
            boolean isBase = false;
            if (suffixLength > 0) {
                File toRenameBase = new File(lowFilename.substring(0, lowFilename.length() - suffixLength));
                if (toRename.exists()) {
                    if (toRenameBase.exists()) {
                        toRenameBase.delete();
                    }
                } else {
                    toRename = toRenameBase;
                    isBase = true;
                }
            }
            if (!toRename.exists()) break;
            if (i == highIndex) {
                if (toRename.delete()) break;
                return false;
            }
            buf.setLength(0);
            this.formatFileName(new Integer(i + 1), buf);
            String renameTo = highFilename = buf.toString();
            if (isBase) {
                renameTo = highFilename.substring(0, highFilename.length() - suffixLength);
            }
            renames.add(new FileRenameAction(toRename, new File(renameTo), true));
            lowFilename = highFilename;
        }
        for (i = renames.size() - 1; i >= 0; --i) {
            Action action = (Action)renames.get(i);
            try {
                if (action.execute()) continue;
                return false;
            }
            catch (Exception ex) {
                LogLog.warn("Exception during purge in RollingFileAppender", ex);
                return false;
            }
        }
        return true;
    }
}

