/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.features.internal.download.impl.AbstractDownloadTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryableDownloadTask
extends AbstractDownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRetryableDownloadTask.class);
    private long scheduleDelay = 250L;
    private int scheduleMaxRun = 9;
    private int scheduleNbRun = 0;

    public AbstractRetryableDownloadTask(ScheduledExecutorService executorService, String url) {
        super(executorService, url);
    }

    public long getScheduleDelay() {
        return this.scheduleDelay;
    }

    public void setScheduleDelay(long scheduleDelay) {
        this.scheduleDelay = scheduleDelay;
    }

    public int getScheduleMaxRun() {
        return this.scheduleMaxRun;
    }

    public void setScheduleMaxRun(int scheduleMaxRun) {
        this.scheduleMaxRun = scheduleMaxRun;
    }

    @Override
    public void run() {
        block5: {
            try {
                try {
                    File file = this.download();
                    this.setFile(file);
                }
                catch (IOException e) {
                    if (++this.scheduleNbRun < this.scheduleMaxRun) {
                        long delay = (long)((double)(this.scheduleDelay * 3L / 2L) + Math.random() * (double)this.scheduleDelay / 2.0);
                        LOGGER.debug("Error downloading " + this.url + ": " + e.getMessage() + ". Retrying in approx " + delay + " ms.");
                        this.executorService.schedule(this, delay, TimeUnit.MILLISECONDS);
                        this.scheduleDelay *= 2L;
                        break block5;
                    }
                    this.setException(new IOException("Error downloading " + this.url, e));
                }
            }
            catch (Throwable e) {
                this.setException(new IOException("Error downloading " + this.url, e));
            }
        }
    }

    protected abstract File download() throws Exception;
}

