/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

public enum TypeCode {
    OBJECT(Object.class),
    BOOLEAN(Boolean.TYPE),
    BYTE(Byte.TYPE),
    CHAR(Character.TYPE),
    SHORT(Short.TYPE),
    INT(Integer.TYPE),
    LONG(Long.TYPE),
    FLOAT(Float.TYPE),
    DOUBLE(Double.TYPE);

    private Class<?> type;

    private TypeCode(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static TypeCode forName(String name) {
        String searchingFor = name.toUpperCase();
        TypeCode[] tcs = TypeCode.values();
        for (int i = 1; i < tcs.length; ++i) {
            if (!tcs[i].name().equals(searchingFor)) continue;
            return tcs[i];
        }
        return OBJECT;
    }

    public static TypeCode forClass(Class<?> c) {
        TypeCode[] allValues = TypeCode.values();
        for (int i = 0; i < allValues.length; ++i) {
            TypeCode typeCode = allValues[i];
            if (c != typeCode.getType()) continue;
            return typeCode;
        }
        return OBJECT;
    }
}

