/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.internal.util.JsonReader;
import org.apache.karaf.features.internal.util.JsonWriter;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public final class DigraphHelper {
    private static final String DIGRAPH_FILE = "digraph.json";
    private static final String REGIONS = "regions";
    private static final String EDGES = "edges";
    private static final String TAIL = "tail";
    private static final String HEAD = "head";
    private static final String POLICY = "policy";

    private DigraphHelper() {
    }

    public static StandardRegionDigraph loadDigraph(BundleContext bundleContext) throws BundleException, IOException, InvalidSyntaxException {
        long id;
        StandardRegionDigraph digraph;
        ThreadLocal<Region> threadLocal = new ThreadLocal<Region>();
        File digraphFile = bundleContext.getDataFile(DIGRAPH_FILE);
        if (digraphFile == null || !digraphFile.exists()) {
            digraph = new StandardRegionDigraph(bundleContext, threadLocal);
        } else {
            try (FileInputStream in = new FileInputStream(digraphFile);){
                digraph = DigraphHelper.readDigraph(new DataInputStream(in), bundleContext, threadLocal);
            }
        }
        Region defaultRegion = digraph.getRegion("root");
        if (defaultRegion == null) {
            defaultRegion = digraph.createRegion("root");
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (Bundle bundle : bundleContext.getBundles()) {
            id = bundle.getBundleId();
            ids.add(id);
            if (digraph.getRegion(id) != null) continue;
            defaultRegion.addBundle(id);
        }
        for (Region region : digraph) {
            HashSet<Long> bundleIds = new HashSet<Long>(region.getBundleIds());
            bundleIds.removeAll(ids);
            Iterator iterator = bundleIds.iterator();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                region.removeBundle(id);
            }
        }
        return digraph;
    }

    public static void saveDigraph(BundleContext bundleContext, RegionDigraph digraph) throws IOException {
        File digraphFile = bundleContext.getDataFile(DIGRAPH_FILE);
        try (FileOutputStream out = new FileOutputStream(digraphFile);){
            DigraphHelper.saveDigraph(digraph, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static StandardRegionDigraph readDigraph(InputStream in, BundleContext bundleContext, ThreadLocal<Region> threadLocal) throws IOException, BundleException, InvalidSyntaxException {
        StandardRegionDigraph digraph = new StandardRegionDigraph(bundleContext, threadLocal);
        Map json = (Map)JsonReader.read(in);
        Map regions = (Map)json.get(REGIONS);
        for (Map.Entry rmap : regions.entrySet()) {
            String name = (String)rmap.getKey();
            Region region = digraph.createRegion(name);
            for (Number b : (Collection)rmap.getValue()) {
                region.addBundle(b.longValue());
            }
        }
        List edges = (List)json.get(EDGES);
        for (Map e : edges) {
            String tail = (String)e.get(TAIL);
            String head = (String)e.get(HEAD);
            Map policy = (Map)e.get(POLICY);
            RegionFilterBuilder builder = digraph.createRegionFilterBuilder();
            for (Map.Entry rf : policy.entrySet()) {
                String ns = (String)rf.getKey();
                for (String f : (Collection)rf.getValue()) {
                    builder.allow(ns, f);
                }
            }
            digraph.connect(digraph.getRegion(tail), builder.build(), digraph.getRegion(head));
        }
        return digraph;
    }

    static void saveDigraph(RegionDigraph digraph, OutputStream out) throws IOException {
        LinkedHashMap<String, Cloneable> json = new LinkedHashMap<String, Cloneable>();
        LinkedHashMap<String, Set<Long>> regions = new LinkedHashMap<String, Set<Long>>();
        json.put(REGIONS, regions);
        for (Region region : digraph.getRegions()) {
            regions.put(region.getName(), region.getBundleIds());
        }
        ArrayList edges = new ArrayList();
        json.put(EDGES, edges);
        for (Region tail : digraph.getRegions()) {
            for (RegionDigraph.FilteredRegion fr : digraph.getEdges(tail)) {
                HashMap<String, Object> edge = new HashMap<String, Object>();
                edge.put(TAIL, tail.getName());
                edge.put(HEAD, fr.getRegion().getName());
                edge.put(POLICY, fr.getFilter().getSharingPolicy());
                edges.add(edge);
            }
        }
        JsonWriter.write(out, json);
    }
}

