/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.shell;

import com.google.common.base.Optional;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;

@Command(scope="opennms-measurements", name="show-newts-samples", description="Show the raw sample stored in Newts")
@Service
public class ShowNewtsSamples
implements Action {
    @Reference(optional=true)
    SampleRepository sampleRepository;
    @Reference
    ResourceDao resourceDao;
    @Option(name="-a", aliases={"--attribute"}, description="Attribute", multiValued=true)
    List<String> attributesSelected;
    @Option(name="-t", aliases={"--raw-timestamps"}, description="Display timestamps as milliseconds from epoch")
    boolean rawTimestamps = false;
    @Option(name="-s", aliases={"--start"}, description="Start Timestamp (epoch ms)")
    long start = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L);
    @Option(name="-e", aliases={"--end"}, description="End Timestamp (epoch ms)")
    long end = System.currentTimeMillis();
    @Argument(index=0, name="resourceId", description="Resource ID", required=true)
    String resourceId;

    public Object execute() {
        if (this.sampleRepository == null) {
            System.out.println("Newts must be enabled to use this command.");
            return null;
        }
        ResourceId resourceIdd = ResourceId.fromString((String)this.resourceId);
        OnmsResource resource = this.resourceDao.getResourceById(resourceIdd);
        if (resource == null) {
            System.out.printf("No resource with ID '%s' found.\n", this.resourceId);
            return null;
        }
        Map attrsByName = resource.getRrdGraphAttributes();
        System.out.printf("Resource with ID '%s' has attributes: %s\n", this.resourceId, attrsByName.keySet());
        Set<Object> filteredAttrNames = attrsByName.keySet();
        if (this.attributesSelected != null && !this.attributesSelected.isEmpty()) {
            filteredAttrNames = attrsByName.keySet().stream().filter(a -> this.attributesSelected.contains(a)).collect(Collectors.toSet());
            System.out.printf("Limiting attributes to: %s\n", filteredAttrNames);
        }
        Set newtsResourceIds = filteredAttrNames.stream().map(attrsByName::get).map(attr -> {
            String newtsResourceId = attr.getRrdRelativePath();
            if (newtsResourceId.startsWith(File.separator)) {
                newtsResourceId = newtsResourceId.substring(File.separator.length());
            }
            return newtsResourceId;
        }).collect(Collectors.toSet());
        for (String newtsResourceId : newtsResourceIds) {
            System.out.printf("Fetching samples for Newts resource ID '%s'...\n", newtsResourceId);
            Results samples = this.sampleRepository.select(Context.DEFAULT_CONTEXT, new Resource(newtsResourceId), Optional.of((Object)Timestamp.fromEpochMillis((long)this.start)), Optional.of((Object)Timestamp.fromEpochMillis((long)this.end)));
            for (Results.Row sampleRow : samples.getRows()) {
                for (Sample sample : sampleRow.getElements()) {
                    if (!filteredAttrNames.contains(sample.getName())) continue;
                    Date date = sample.getTimestamp().asDate();
                    System.out.printf("%s,%s,%.4f\n", this.rawTimestamps ? Long.valueOf(date.getTime()) : date, sample.getName(), sample.getValue().doubleValue());
                }
            }
        }
        return null;
    }
}

