/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.measurements.api.FilterEngine;
import org.opennms.netmgt.measurements.api.MeasurementsService;
import org.opennms.netmgt.measurements.api.exceptions.ExpressionException;
import org.opennms.netmgt.measurements.api.exceptions.FetchException;
import org.opennms.netmgt.measurements.api.exceptions.FilterException;
import org.opennms.netmgt.measurements.api.exceptions.ResourceNotFoundException;
import org.opennms.netmgt.measurements.api.exceptions.ValidationException;
import org.opennms.netmgt.measurements.model.FilterMetaData;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.measurements.model.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
@Path(value="measurements")
public class MeasurementsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementsRestService.class);
    @Autowired
    private MeasurementsService service;
    @Autowired
    private FilterEngine filterEngine;

    @GET
    @Path(value="filters")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public List<FilterMetaData> getFilterMetadata() {
        return this.filterEngine.getFilterMetaData();
    }

    @GET
    @Path(value="filters/{name}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public FilterMetaData getFilterMetadata(@PathParam(value="name") String name) {
        FilterMetaData metaData = this.filterEngine.getFilterMetaData(name);
        if (metaData == null) {
            throw MeasurementsRestService.getException(Response.Status.NOT_FOUND, "No filter with name '{}' was found.", name);
        }
        return metaData;
    }

    @GET
    @Path(value="{resourceId}/{attribute}")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public QueryResponse simpleQuery(@PathParam(value="resourceId") String resourceId, @PathParam(value="attribute") String attribute, @DefaultValue(value="-14400000") @QueryParam(value="start") long start, @DefaultValue(value="0") @QueryParam(value="end") long end, @DefaultValue(value="300000") @QueryParam(value="step") long step, @DefaultValue(value="0") @QueryParam(value="maxrows") int maxrows, @DefaultValue(value="") @QueryParam(value="fallback-attribute") String fallbackAttribute, @DefaultValue(value="AVERAGE") @QueryParam(value="aggregation") String aggregation) {
        QueryRequest request = new QueryRequest();
        request.setEnd(end > 0L ? end : new Date().getTime());
        request.setStart(start >= 0L ? start : request.getEnd() + start);
        if (request.getStart() < 0L) {
            request.setStart(0L);
        }
        request.setStep(step);
        request.setMaxRows(maxrows);
        Source source = new Source(attribute, resourceId, attribute, attribute, false);
        source.setFallbackAttribute(fallbackAttribute);
        source.setAggregation(aggregation);
        request.setSources((List)Lists.newArrayList((Object[])new Source[]{source}));
        return this.query(request);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public QueryResponse query(QueryRequest request) {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0);
        LOG.debug("Executing query with {}", (Object)request);
        QueryResponse response = null;
        try {
            response = this.service.query(request);
        }
        catch (ExpressionException e) {
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, e, "An error occurred while evaluating an expression: {}", e.getMessage());
        }
        catch (FilterException | ValidationException e) {
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, e, e.getMessage(), new Object[0]);
        }
        catch (ResourceNotFoundException e) {
            throw MeasurementsRestService.getException(Response.Status.NOT_FOUND, e, e.getMessage(), new Object[0]);
        }
        catch (FetchException e) {
            throw MeasurementsRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, e, e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            throw MeasurementsRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, e, "Query failed: {}", e.getMessage());
        }
        if (response.getColumns().length == 0) {
            throw MeasurementsRestService.getException(Response.Status.NO_CONTENT, "No content.", new Object[0]);
        }
        return response;
    }

    protected static WebApplicationException getException(Response.Status status, String msg, Object ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected static WebApplicationException getException(Response.Status status, Throwable t, String msg, Object ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg, t);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }
}

