/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.ExpressionException;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.impl.JEXLExpressionEngine;
import org.opennms.netmgt.measurements.model.Expression;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.measurements.model.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
@Path(value="measurements")
public class MeasurementsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementsRestService.class);
    @Autowired
    private MeasurementFetchStrategy m_fetchStrategy;
    private final ExpressionEngine expressionEngine = new JEXLExpressionEngine();

    @GET
    @Path(value="{resourceId}/{attribute}")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public QueryResponse simpleQuery(@PathParam(value="resourceId") String resourceId, @PathParam(value="attribute") String attribute, @DefaultValue(value="-14400000") @QueryParam(value="start") long start, @DefaultValue(value="0") @QueryParam(value="end") long end, @DefaultValue(value="300000") @QueryParam(value="step") long step, @DefaultValue(value="0") @QueryParam(value="maxrows") int maxrows, @DefaultValue(value="AVERAGE") @QueryParam(value="aggregation") String aggregation) {
        QueryRequest request = new QueryRequest();
        request.setEnd(end > 0L ? end : new Date().getTime());
        request.setStart(start >= 0L ? start : request.getEnd() + start);
        if (request.getStart() < 0L) {
            request.setStart(0L);
        }
        request.setStep(step);
        request.setMaxRows(maxrows);
        Source source = new Source(attribute, resourceId, attribute, false);
        source.setAggregation(aggregation);
        request.setSources((List)Lists.newArrayList((Object[])new Source[]{source}));
        return this.query(request);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public QueryResponse query(QueryRequest request) {
        FetchResults results;
        Preconditions.checkState((this.m_fetchStrategy != null ? 1 : 0) != 0);
        MeasurementsRestService.validateQueryRequest(request);
        LOG.debug("Executing query with {}", (Object)request);
        try {
            results = this.m_fetchStrategy.fetch(request.getStart(), request.getEnd(), request.getStep(), request.getMaxRows(), request.getSources());
        }
        catch (Exception e) {
            throw MeasurementsRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, e, "Fetch failed", new Object[0]);
        }
        if (results == null) {
            throw MeasurementsRestService.getException(Response.Status.NOT_FOUND, "Resource or attribute not found for {}", request);
        }
        try {
            this.expressionEngine.applyExpressions(request, results);
        }
        catch (ExpressionException e) {
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, e, "An error occured while evaluating an expression.", new Object[0]);
        }
        Map columns = results.getColumns();
        for (Source source : request.getSources()) {
            if (!source.getTransient()) continue;
            columns.remove(source.getLabel());
        }
        if (columns.keySet().size() == 0) {
            throw MeasurementsRestService.getException(Response.Status.NO_CONTENT, "No content.", new Object[0]);
        }
        QueryResponse response = new QueryResponse();
        response.setStart(request.getStart());
        response.setEnd(request.getEnd());
        response.setStep(results.getStep());
        response.setTimestamps(results.getTimestamps());
        response.setColumns(columns);
        return response;
    }

    private static void validateQueryRequest(QueryRequest request) {
        if (request.getEnd() < 0L) {
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, "Query end must be >= 0: {}", request.getEnd());
        }
        if (request.getStep() <= 0L) {
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, "Query step must be > 0: {}", request.getStep());
        }
        for (Source source : request.getSources()) {
            if (source.getResourceId() != null && source.getAttribute() != null && source.getLabel() != null && source.getAggregation() != null) continue;
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, "Query source fields must be set: {}", source);
        }
        for (Expression expression : request.getExpressions()) {
            if (expression.getExpression() != null && expression.getLabel() != null) continue;
            throw MeasurementsRestService.getException(Response.Status.BAD_REQUEST, "Query expression fields must be set: {}", expression);
        }
    }

    protected static <T> WebApplicationException getException(Response.Status status, String msg, Object ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected static <T> WebApplicationException getException(Response.Status status, Throwable t, String msg, Object ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg, t);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }
}

