/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.filters.impl.Utils;

@FilterInfo(name="Chomp", description="Strips leading and trailing rows that contain nothing but NaNs/null values.")
public class Chomp
implements Filter {
    @FilterParam(key="stripNaNs", value="true", displayName="Strip", description="When set, leading and trailing rows containing NaNs will be removed")
    private boolean m_stripNaNs;
    @FilterParam(key="cutoffDate", value="0", displayName="Cutoff", description="Timestamp in milliseconds. Any rows before this time will be removed.")
    private double m_cutoffDate;

    protected Chomp() {
    }

    public Chomp(double cutOffDate, boolean stripNaNs) {
        this.m_cutoffDate = cutOffDate;
        this.m_stripNaNs = stripNaNs;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) throws Exception {
        long i;
        long lastRowToKeep;
        int numRowsInTable = qrAsTable.rowKeySet().size();
        long firstRowToKeep = lastRowToKeep = (long)numRowsInTable;
        Iterator iterator = qrAsTable.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long k = (Long)iterator.next();
            if (!((Double)qrAsTable.get((Object)k, (Object)"timestamp") >= this.m_cutoffDate)) continue;
            firstRowToKeep = k;
            break;
        }
        if (this.m_stripNaNs) {
            HashSet columnNamesNoTs = Sets.newHashSet((Iterable)qrAsTable.columnKeySet());
            columnNamesNoTs.remove("timestamp");
            Utils.TableLimits limits = Utils.getRowsWithValues(qrAsTable, columnNamesNoTs.toArray(new String[0]));
            firstRowToKeep = Math.max(firstRowToKeep, limits.firstRowWithValues);
            lastRowToKeep = Math.min(lastRowToKeep, limits.lastRowWithValues);
        }
        HashSet columnNames = Sets.newHashSet((Iterable)qrAsTable.columnKeySet());
        for (i = lastRowToKeep + 1L; i < (long)numRowsInTable; ++i) {
            for (String columnName : columnNames) {
                qrAsTable.remove((Object)i, (Object)columnName);
            }
        }
        for (i = 0L; i < firstRowToKeep; ++i) {
            for (String columnName : columnNames) {
                qrAsTable.remove((Object)i, (Object)columnName);
            }
        }
        if (firstRowToKeep > 0L) {
            long j = 0L;
            for (long i2 = firstRowToKeep; i2 <= lastRowToKeep; ++i2) {
                for (String columnName : columnNames) {
                    Double value = (Double)qrAsTable.get((Object)i2, (Object)columnName);
                    if (value != null) {
                        qrAsTable.put((Object)j, (Object)columnName, (Object)value);
                    }
                    qrAsTable.remove((Object)i2, (Object)columnName);
                }
                ++j;
            }
        }
    }
}

