/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.TreeBasedTable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.filters.impl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterInfo(name="HoltWinters", description="Performs Holt-Winters forecasting.", backend="R")
public class HWForecast
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HWForecast.class);
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/measurements/filters/impl/holtWinters.R";
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="outputPrefix", value="HW", displayName="Output", description="Output prefix.")
    private String m_outputPrefix;
    @FilterParam(key="numPeriodsToForecast", value="3", displayName="# Periods", description="Number of periods to forecast.")
    private int m_numPeriodsToForecast;
    @FilterParam(key="periodInSeconds", required=true, displayName="Period", description="Size of a period in seconds.")
    private long m_periodInSeconds;
    @FilterParam(key="confidenceLevel", value="0.95", displayName="Level", description="Probability used for confidence bounds. Set this to 0 in order to disable the bounds.")
    private double m_confidenceLevel;

    protected HWForecast() {
    }

    public HWForecast(String outputPrefix, String inputColumn, int numPeriodsToForecast, long periodInSeconds, double confidenceLevel) {
        this.m_outputPrefix = outputPrefix;
        this.m_inputColumn = inputColumn;
        this.m_numPeriodsToForecast = numPeriodsToForecast;
        this.m_periodInSeconds = periodInSeconds;
        this.m_confidenceLevel = confidenceLevel;
    }

    public void filter(RowSortedTable<Long, String, Double> table) throws RScriptException {
        long i;
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"timestamp"), (Object)String.format("Data source must have a '%s' column.", "timestamp"));
        Utils.TableLimits limits = Utils.getRowsWithValues(table, new String[]{this.m_inputColumn});
        long numSampleRows = limits.lastRowWithValues - limits.firstRowWithValues;
        if (numSampleRows < 1L) {
            LOG.error("Insufficient values in column for forecasting. Excluding forecast columns from data source.");
            return;
        }
        Date lastTimestamp = new Date(((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp") - (Double)table.get((Object)(limits.lastRowWithValues - 1L), (Object)"timestamp"));
        int numSamplesPerPeriod = (int)Math.floor((double)this.m_periodInSeconds * 1000.0 / (double)stepInMs);
        numSamplesPerPeriod = Math.max(1, numSamplesPerPeriod);
        int numForecasts = numSamplesPerPeriod * this.m_numPeriodsToForecast;
        HashMap arguments = Maps.newHashMap();
        arguments.put("columnToForecast", this.m_inputColumn);
        arguments.put("numSamplesPerSeason", numSamplesPerPeriod);
        arguments.put("numForecasts", numForecasts);
        arguments.put("confidenceLevel", this.m_confidenceLevel);
        arguments.put("firstIndex", limits.firstRowWithValues + 1L);
        arguments.put("lastIndex", limits.lastRowWithValues + 1L);
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(table, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        int numOutputRows = outputTable.rowKeySet().size();
        int numFittedValues = numOutputRows - numForecasts;
        for (i = 0L; i < (long)numFittedValues; ++i) {
            long idxTarget = i + (numSampleRows - (long)numFittedValues) + limits.firstRowWithValues + 1L;
            table.put((Object)idxTarget, (Object)(this.m_outputPrefix + "Fit"), outputTable.get((Object)i, (Object)"fit"));
        }
        for (i = (long)numFittedValues; i < (long)numOutputRows; ++i) {
            long idxForecast = i - (long)numFittedValues + 1L;
            long idxTarget = limits.lastRowWithValues + idxForecast;
            if (this.m_confidenceLevel > 0.0) {
                table.put((Object)idxTarget, (Object)(this.m_outputPrefix + "Fit"), outputTable.get((Object)i, (Object)"fit"));
                table.put((Object)idxTarget, (Object)(this.m_outputPrefix + "Lwr"), outputTable.get((Object)i, (Object)"lwr"));
                table.put((Object)idxTarget, (Object)(this.m_outputPrefix + "Upr"), outputTable.get((Object)i, (Object)"upr"));
            }
            table.put((Object)idxTarget, (Object)"timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * idxForecast).getTime());
        }
    }

    public static void checkForecastSupport() throws RScriptException {
        HWForecast forecastFilter = new HWForecast("HW", "X", 1, 1L, 0.95);
        TreeBasedTable table = TreeBasedTable.create();
        for (long i = 0L; i < 100L; ++i) {
            table.put((Object)i, (Object)"timestamp", (Object)(i * 1000L));
            table.put((Object)i, (Object)"X", (Object)1.0);
        }
        forecastFilter.filter((RowSortedTable<Long, String, Double>)table);
    }
}

