/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;

@FilterInfo(name="Outlier", description="Removes outliers and replaces them with interpolated values.")
public class OutlierFilter
implements Filter {
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="quantile", value="0.95", displayName="Quantile", description="Quantile level. Must be > 0 and <= 100. Any values greater than the calculated percentile will be replaced with an interpolated value.")
    private double m_quantile;

    protected OutlierFilter() {
    }

    public OutlierFilter(String inputColumn, double quantile) {
        this.m_inputColumn = inputColumn;
        this.m_quantile = quantile;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) {
        Map column = qrAsTable.column((Object)this.m_inputColumn);
        double[] values = new double[column.size()];
        int k = 0;
        for (Double value : column.values()) {
            values[k++] = value;
        }
        Percentile percentileCalculator = new Percentile();
        Double nthPercentile = percentileCalculator.evaluate(values, 100.0 * this.m_quantile);
        for (Map.Entry entry : column.entrySet()) {
            if (((Double)entry.getValue()).isNaN() || !((Double)entry.getValue() > nthPercentile)) continue;
            entry.setValue(Double.NaN);
        }
        this.linearInterpolation(qrAsTable);
    }

    public void linearInterpolation(RowSortedTable<Long, String, Double> qrAsTable) {
        Map column = qrAsTable.column((Object)this.m_inputColumn);
        HashMap interpolatedValues = Maps.newHashMap();
        Long x0 = null;
        for (Map.Entry entry : column.entrySet()) {
            long x = (Long)entry.getKey();
            double y = (Double)entry.getValue();
            if (Double.isNaN(y)) continue;
            if (x0 != null && x0 != x - 1L) {
                double y0 = (Double)column.get(x0);
                double m = (y0 - y) / (double)(x0 - x);
                double b = y0 - m * (double)x0.longValue();
                for (long xnot = x0 + 1L; xnot < x; ++xnot) {
                    double ynot = m * (double)xnot + b;
                    interpolatedValues.put(xnot, ynot);
                }
            }
            x0 = x;
        }
        column.putAll(interpolatedValues);
    }
}

