/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.exceptions.ExpressionException;
import org.opennms.netmgt.measurements.model.Expression;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="expressionEngine")
public class JEXLExpressionEngine
implements ExpressionEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JEXLExpressionEngine.class);
    private final JexlEngine jexl = new JexlEngine();

    public JEXLExpressionEngine() {
        HashMap functions = Maps.newHashMap();
        functions.put("math", Math.class);
        functions.put("strictmath", StrictMath.class);
        this.jexl.setFunctions((Map)functions);
    }

    public void applyExpressions(QueryRequest request, FetchResults results) throws ExpressionException {
        int j;
        Preconditions.checkNotNull((Object)request, (Object)"request argument");
        Preconditions.checkNotNull((Object)results, (Object)"results argument");
        int numExpressions = request.getExpressions().size();
        if (numExpressions < 1) {
            return;
        }
        int numNonTransientExpression = 0;
        boolean[] transientFlags = new boolean[numExpressions];
        int k = 0;
        LinkedHashMap expressions = Maps.newLinkedHashMap();
        for (Expression e : request.getExpressions()) {
            transientFlags[k] = e.getTransient();
            if (!transientFlags[k]) {
                ++numNonTransientExpression;
            }
            ++k;
            try {
                expressions.put(e.getLabel(), this.jexl.createExpression(e.getExpression()));
            }
            catch (JexlException ex) {
                throw new ExpressionException((Throwable)ex, "Failed to parse expression label '{}'.", new Object[]{e.getLabel()});
            }
        }
        HashMap jexlValues = Maps.newHashMap();
        MapContext context = new MapContext((Map)jexlValues);
        jexlValues.putAll(results.getConstants());
        LOG.debug("JEXL context constants: {}", (Object)jexlValues);
        jexlValues.put("__inf", Double.POSITIVE_INFINITY);
        jexlValues.put("__neg_inf", Double.NEGATIVE_INFINITY);
        jexlValues.put("NaN", Double.NaN);
        long[] timestamps = results.getTimestamps();
        Map columns = results.getColumns();
        int numRows = timestamps.length;
        double[][] expressionValues = new double[numNonTransientExpression][numRows];
        for (int i = 0; i < numRows; ++i) {
            k = 0;
            j = 0;
            for (Map.Entry expressionEntry : expressions.entrySet()) {
                jexlValues.put("timestamp", timestamps[i]);
                for (String sourceLabel : columns.keySet()) {
                    jexlValues.put(sourceLabel, ((double[])columns.get(sourceLabel))[i]);
                }
                try {
                    Object derived = ((org.apache.commons.jexl2.Expression)expressionEntry.getValue()).evaluate((JexlContext)context);
                    double derivedAsDouble = Utils.toDouble((Object)derived);
                    if (!transientFlags[j++]) {
                        expressionValues[k++][i] = derivedAsDouble;
                    }
                    jexlValues.put(expressionEntry.getKey(), derivedAsDouble);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ExpressionException((Throwable)e, "The return value from expression with label '" + (String)expressionEntry.getKey() + "' could not be cast to a Double.", new Object[0]);
                }
                catch (JexlException e) {
                    throw new ExpressionException((Throwable)e, "Failed to evaluate expression with label '" + (String)expressionEntry.getKey() + "'.", new Object[0]);
                }
            }
        }
        k = 0;
        j = 0;
        for (String expressionLabel : expressions.keySet()) {
            if (transientFlags[j++]) continue;
            columns.put(expressionLabel, expressionValues[k++]);
        }
    }
}

