/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrobin.core.RrdException;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRrdBasedFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRrdBasedFetchStrategy.class);
    @Autowired
    private ResourceDao m_resourceDao;

    public FetchResults fetch(long start, long end, long step, int maxrows, List<Source> sources) throws Exception {
        HashMap constants = Maps.newHashMap();
        HashMap rrdsBySource = Maps.newHashMap();
        for (Source source : sources) {
            OnmsResource resource = this.m_resourceDao.getResourceById(source.getResourceId());
            if (resource == null) {
                LOG.error("No resource with id: {}", (Object)source.getResourceId());
                return null;
            }
            RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
            if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                source.setAttribute(source.getFallbackAttribute());
                source.setFallbackAttribute(null);
                rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
            }
            if (rrdGraphAttribute == null) {
                LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                return null;
            }
            Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)resource.getStringPropertyAttributes(), (Map)constants);
            String rrdFile = System.getProperty("rrd.base.dir") + File.separator + rrdGraphAttribute.getRrdRelativePath();
            rrdsBySource.put(source, rrdFile);
        }
        return this.fetchMeasurements(start, end, step, maxrows, rrdsBySource, constants);
    }

    protected abstract FetchResults fetchMeasurements(long var1, long var3, long var5, int var7, Map<Source, String> var8, Map<String, Object> var9) throws RrdException;
}

