/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.filters.impl.TrendLineConfig;
import org.opennms.netmgt.measurements.filters.impl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrendLine
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TrendLine.class);
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/measurements/filters/impl/trendLine.R";
    private final TrendLineConfig m_config;

    public TrendLine(TrendLineConfig config) {
        this.m_config = config;
    }

    public void filter(RowSortedTable<Long, String, Double> table) throws RScriptException {
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"timestamp"), (Object)String.format("Data source must have a '%s' column.", "timestamp"));
        Utils.TableLimits limits = Utils.getRowsWithValues(table, new String[]{this.m_config.getInputColumn()});
        long numSampleRows = limits.lastRowWithValues - limits.firstRowWithValues;
        if (numSampleRows < 1L) {
            LOG.error("Insufficient values in column for trending. Excluding trend from data source.");
            return;
        }
        Date lastTimestamp = new Date(((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp") - (Double)table.get((Object)(limits.lastRowWithValues - 1L), (Object)"timestamp"));
        int numStepsAhead = (int)Math.floor(this.m_config.getSecondsAhead() * 1000L / stepInMs);
        numStepsAhead = Math.max(1, numStepsAhead);
        HashMap arguments = Maps.newHashMap();
        arguments.put("inputColumn", this.m_config.getInputColumn());
        arguments.put("polynomialOrder", this.m_config.getPolynomialOrder());
        arguments.put("firstIndex", limits.firstRowWithValues + 1L);
        arguments.put("lastIndex", limits.lastRowWithValues + 1L);
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(table, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        Polynomial poly = new Polynomial((Double[])outputTable.column((Object)"x").values().toArray((Object[])new Double[0]));
        for (long i = limits.firstRowWithValues; i <= limits.lastRowWithValues + (long)numStepsAhead; ++i) {
            if (i >= limits.lastRowWithValues) {
                table.put((Object)i, (Object)"timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * (i - limits.lastRowWithValues)).getTime());
            }
            double x = (Double)table.get((Object)i, (Object)"timestamp");
            table.put((Object)i, (Object)this.m_config.getOutputColumn(), (Object)poly.eval(x));
        }
    }

    private static class Polynomial {
        private final List<Double> m_coeffs = Lists.newLinkedList();

        public Polynomial(Double[] coeffs) {
            for (int i = 0; i < coeffs.length && coeffs[i] != null && !Double.isNaN(coeffs[i]); ++i) {
                this.m_coeffs.add(coeffs[i]);
            }
        }

        public double eval(double x) {
            double sum = 0.0;
            int k = 0;
            for (Double coeff : this.m_coeffs) {
                sum += coeff * Math.pow(x, k++);
            }
            return sum;
        }

        public String toString() {
            return "Polynomial [" + this.m_coeffs + "]";
        }
    }
}

