/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.filters.impl.OutlierFilterConfig;

public class OutlierFilter
implements Filter {
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/measurements/filters/impl/outlierFilter.R";
    private final OutlierFilterConfig m_config;

    public OutlierFilter(OutlierFilterConfig config) {
        this.m_config = config;
    }

    public void filter(RowSortedTable<Long, String, Double> dsAsTable) throws RScriptException {
        String columnToFilter = this.m_config.getInputColumn();
        HashMap arguments = Maps.newHashMap();
        arguments.put("columnToFilter", columnToFilter);
        arguments.put("probability", this.m_config.getProbability());
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(dsAsTable, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        int numRowsInTable = dsAsTable.rowKeySet().size();
        for (long i = 0L; i < (long)numRowsInTable; ++i) {
            dsAsTable.put((Object)i, (Object)columnToFilter, outputTable.get((Object)i, (Object)columnToFilter));
        }
        this.linearInterpolation(dsAsTable);
    }

    public void linearInterpolation(RowSortedTable<Long, String, Double> dsAsTable) {
        String columnToFilter = this.m_config.getInputColumn();
        Map column = dsAsTable.column((Object)columnToFilter);
        HashMap interpolatedValues = Maps.newHashMap();
        Long x0 = null;
        for (Map.Entry entry : column.entrySet()) {
            long x = (Long)entry.getKey();
            double y = (Double)entry.getValue();
            if (Double.isNaN(y)) continue;
            if (x0 != null && x0 != x - 1L) {
                double y0 = (Double)column.get(x0);
                double m = (y0 - y) / (double)(x0 - x);
                double b = y0 - m * (double)x0.longValue();
                for (long xnot = x0 + 1L; xnot < x; ++xnot) {
                    double ynot = m * (double)xnot + b;
                    interpolatedValues.put(xnot, ynot);
                }
            }
            x0 = x;
        }
        column.putAll(interpolatedValues);
    }
}

