/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.filters.impl.HWForecastConfig;
import org.opennms.netmgt.measurements.filters.impl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HWForecast
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HWForecast.class);
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/measurements/filters/impl/holtWinters.R";
    private final HWForecastConfig m_config;

    public HWForecast(HWForecastConfig config) {
        this.m_config = config;
    }

    public void filter(RowSortedTable<Long, String, Double> table) throws RScriptException {
        long i;
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"timestamp"), (Object)String.format("Data source must have a '%s' column.", "timestamp"));
        Utils.TableLimits limits = Utils.getRowsWithValues(table, new String[]{this.m_config.getInputColumn()});
        long numSampleRows = limits.lastRowWithValues - limits.firstRowWithValues;
        if (numSampleRows < 1L) {
            LOG.error("Insufficient values in column for forecasting. Excluding forecast columns from data source.");
            return;
        }
        Date lastTimestamp = new Date(((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp") - (Double)table.get((Object)(limits.lastRowWithValues - 1L), (Object)"timestamp"));
        int numSamplesPerPeriod = (int)Math.floor(this.m_config.getPeriodInSeconds() * 1000L / stepInMs);
        numSamplesPerPeriod = Math.max(1, numSamplesPerPeriod);
        int numForecasts = numSamplesPerPeriod * this.m_config.getNumPeriodsToForecast();
        HashMap arguments = Maps.newHashMap();
        arguments.put("columnToForecast", this.m_config.getInputColumn());
        arguments.put("numSamplesPerSeason", numSamplesPerPeriod);
        arguments.put("numForecasts", numForecasts);
        arguments.put("confidenceLevel", this.m_config.getConfidenceLevel());
        arguments.put("firstIndex", limits.firstRowWithValues + 1L);
        arguments.put("lastIndex", limits.lastRowWithValues + 1L);
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(table, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        int numOutputRows = outputTable.rowKeySet().size();
        int numFittedValues = numOutputRows - numForecasts;
        for (i = 0L; i < (long)numFittedValues; ++i) {
            long idxTarget = i + (numSampleRows - (long)numFittedValues) + limits.firstRowWithValues + 1L;
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Fit"), outputTable.get((Object)i, (Object)"fit"));
        }
        for (i = (long)numFittedValues; i < (long)numOutputRows; ++i) {
            long idxForecast = i - (long)numFittedValues + 1L;
            long idxTarget = limits.lastRowWithValues + idxForecast;
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Fit"), outputTable.get((Object)i, (Object)"fit"));
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Lwr"), outputTable.get((Object)i, (Object)"lwr"));
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Upr"), outputTable.get((Object)i, (Object)"upr"));
            table.put((Object)idxTarget, (Object)"timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * idxForecast).getTime());
        }
    }
}

