/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.filters.impl.ChompConfig;
import org.opennms.netmgt.measurements.filters.impl.Utils;

public class Chomp
implements Filter {
    private final ChompConfig m_config;

    public Chomp(ChompConfig config) {
        this.m_config = config;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) throws Exception {
        long lastRowToKeep;
        int numRowsInTable = qrAsTable.rowKeySet().size();
        long firstRowToKeep = lastRowToKeep = (long)numRowsInTable;
        Iterator iterator = qrAsTable.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long k = (Long)iterator.next();
            if (!((Double)qrAsTable.get((Object)k, (Object)"timestamp") >= this.m_config.getCutoffDate())) continue;
            firstRowToKeep = k;
            break;
        }
        if (this.m_config.getStripNaNs()) {
            HashSet columnNamesNoTs = Sets.newHashSet((Iterable)qrAsTable.columnKeySet());
            columnNamesNoTs.remove("timestamp");
            Utils.TableLimits limits = Utils.getRowsWithValues(qrAsTable, columnNamesNoTs.toArray(new String[0]));
            firstRowToKeep = Math.max(firstRowToKeep, limits.firstRowWithValues);
            lastRowToKeep = Math.min(lastRowToKeep, limits.lastRowWithValues);
        }
        HashSet columnNames = Sets.newHashSet((Iterable)qrAsTable.columnKeySet());
        for (long i = lastRowToKeep + 1L; i < (long)numRowsInTable; ++i) {
            for (String columnName : columnNames) {
                qrAsTable.remove((Object)i, (Object)columnName);
            }
        }
        int i = 0;
        while ((long)i < firstRowToKeep) {
            for (String columnName : columnNames) {
                qrAsTable.remove((Object)i, (Object)columnName);
            }
            ++i;
        }
        if (firstRowToKeep > 0L) {
            long j = 0L;
            for (long i2 = firstRowToKeep; i2 <= lastRowToKeep; ++i2) {
                for (String columnName : columnNames) {
                    Double value = (Double)qrAsTable.get((Object)i2, (Object)columnName);
                    if (value != null) {
                        qrAsTable.put((Object)j, (Object)columnName, (Object)value);
                    }
                    qrAsTable.remove((Object)i2, (Object)columnName);
                }
                ++j;
            }
        }
    }
}

