/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterConfig;
import org.opennms.netmgt.measurements.api.FilterFactory;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.model.FilterDefinition;
import org.opennms.netmgt.measurements.model.FilterParameter;

public abstract class AbstractFilterFactory<T extends FilterConfig>
implements FilterFactory {
    private final Class<T> type;

    public AbstractFilterFactory(Class<T> type) {
        this.type = type;
    }

    public abstract boolean supports(FilterDefinition var1);

    public abstract Filter createFilter(T var1);

    public Class<T> getFilterConfigType() {
        return this.type;
    }

    public Filter getFilter(FilterDefinition filterDef) {
        FilterConfig filterConfig;
        if (!this.supports(filterDef)) {
            return null;
        }
        HashMap parameterMap = Maps.newHashMap();
        for (FilterParameter param : filterDef.getParameters()) {
            parameterMap.put(param.getName(), param.getValue());
        }
        try {
            filterConfig = (FilterConfig)this.type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (Field field : this.type.getDeclaredFields()) {
            FilterParam filterParam = field.getAnnotation(FilterParam.class);
            if (filterParam == null) continue;
            String effectiveValueAsStr = null;
            if (parameterMap.containsKey(filterParam.name())) {
                effectiveValueAsStr = (String)parameterMap.get(filterParam.name());
            } else if (!filterParam.required()) {
                effectiveValueAsStr = filterParam.value();
            } else {
                throw new IllegalArgumentException("Parameter with name '" + filterParam.name() + "' is required, but no value was given.");
            }
            Object effectiveValue = effectiveValueAsStr;
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                effectiveValue = Boolean.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                effectiveValue = Double.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                effectiveValue = Integer.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                effectiveValue = Long.valueOf(effectiveValueAsStr);
            }
            try {
                field.setAccessible(true);
                field.set(filterConfig, effectiveValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return this.createFilter(filterConfig);
    }
}

