/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.ExpressionException;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.model.Expression;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.utils.Utils;

public class JEXLExpressionEngine
implements ExpressionEngine {
    private final JexlEngine jexl = new JexlEngine();

    public JEXLExpressionEngine() {
        HashMap functions = Maps.newHashMap();
        functions.put("math", Math.class);
        functions.put("strictmath", StrictMath.class);
        this.jexl.setFunctions((Map)functions);
    }

    public void applyExpressions(QueryRequest request, FetchResults results) throws ExpressionException {
        int j;
        Preconditions.checkNotNull((Object)request, (Object)"request argument");
        Preconditions.checkNotNull((Object)results, (Object)"results argument");
        int numExpressions = request.getExpressions().size();
        if (numExpressions < 1) {
            return;
        }
        int numNonTransientExpression = 0;
        boolean[] transientFlags = new boolean[numExpressions];
        int k = 0;
        LinkedHashMap expressions = Maps.newLinkedHashMap();
        for (Expression e : request.getExpressions()) {
            transientFlags[k] = e.getTransient();
            if (!transientFlags[k]) {
                ++numNonTransientExpression;
            }
            ++k;
            try {
                expressions.put(e.getLabel(), this.jexl.createExpression(e.getExpression()));
            }
            catch (JexlException ex) {
                throw new ExpressionException("Failed to parse expression label '" + e.getLabel() + "'.", (RuntimeException)((Object)ex));
            }
        }
        HashMap jexlValues = Maps.newHashMap();
        MapContext context = new MapContext((Map)jexlValues);
        jexlValues.putAll(results.getConstants());
        jexlValues.put("__inf", Double.POSITIVE_INFINITY);
        jexlValues.put("__neg_inf", Double.NEGATIVE_INFINITY);
        long[] timestamps = results.getTimestamps();
        Map columns = results.getColumns();
        int numRows = timestamps.length;
        double[][] expressionValues = new double[numNonTransientExpression][numRows];
        for (int i = 0; i < numRows; ++i) {
            k = 0;
            j = 0;
            for (Map.Entry expressionEntry : expressions.entrySet()) {
                jexlValues.put("timestamp", timestamps[i]);
                for (String sourceLabel : columns.keySet()) {
                    jexlValues.put(sourceLabel, ((double[])columns.get(sourceLabel))[i]);
                }
                try {
                    Object derived = ((org.apache.commons.jexl2.Expression)expressionEntry.getValue()).evaluate((JexlContext)context);
                    double derivedAsDouble = Utils.toDouble((Object)derived);
                    if (!transientFlags[j++]) {
                        expressionValues[k++][i] = derivedAsDouble;
                    }
                    jexlValues.put(expressionEntry.getKey(), derivedAsDouble);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new ExpressionException("The return value from expression with label '" + (String)expressionEntry.getKey() + "' could not be cast to a Double.", e);
                }
                catch (JexlException e) {
                    throw new ExpressionException("Failed to evaluate expression with label '" + (String)expressionEntry.getKey() + "'.", (RuntimeException)((Object)e));
                }
            }
        }
        k = 0;
        j = 0;
        for (String expressionLabel : expressions.keySet()) {
            if (transientFlags[j++]) continue;
            columns.put(expressionLabel, expressionValues[k++]);
        }
    }
}

