/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.measurements.model.QueryNode;
import org.opennms.netmgt.measurements.model.QueryResource;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="metadata")
public class QueryMetadata {
    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    private final List<QueryResource> resources;
    @XmlElementWrapper(name="nodes")
    @XmlElement(name="node")
    private final Set<QueryNode> nodes;

    public QueryMetadata() {
        this.resources = null;
        this.nodes = null;
    }

    public QueryMetadata(List<QueryResource> resources) {
        this.resources = resources;
        if (resources != null) {
            TreeSet nodes = Sets.newTreeSet();
            for (QueryResource resource : resources) {
                QueryNode node = resource.getNode();
                if (node == null) continue;
                nodes.add(node);
            }
            this.nodes = nodes;
        } else {
            this.nodes = null;
        }
    }

    public List<QueryResource> getResources() {
        return this.resources == null ? new ArrayList() : this.resources;
    }

    public Set<QueryNode> getNodes() {
        return this.nodes == null ? new HashSet() : this.nodes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryMetadata other = (QueryMetadata)obj;
        return Objects.equals(this.resources, other.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resources", this.resources).add("nodes", this.nodes).toString();
    }
}

