/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="source")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Source {
    private String label;
    private String resourceId;
    private String attribute;
    private String fallbackAttribute;
    private String datasource;
    private String aggregation = "AVERAGE";
    private boolean isTransient = false;

    public Source() {
    }

    public Source(String label, String resourceId, String attribute, String datasource, boolean isTransient) {
        this.label = (String)Preconditions.checkNotNull((Object)label, (Object)"label argument");
        this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId argument");
        this.attribute = (String)Preconditions.checkNotNull((Object)attribute, (Object)"attribute argument");
        this.datasource = datasource;
        this.isTransient = isTransient;
    }

    @XmlAttribute(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute(name="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @XmlAttribute(name="attribute")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @XmlAttribute(name="fallback-attribute")
    public String getFallbackAttribute() {
        return this.fallbackAttribute;
    }

    public void setFallbackAttribute(String fallbackAttribute) {
        this.fallbackAttribute = fallbackAttribute;
    }

    @XmlAttribute(name="datasource")
    public String getDataSource() {
        return this.datasource;
    }

    public void setDataSource(String datasource) {
        this.datasource = datasource;
    }

    @XmlTransient
    public String getEffectiveDataSource() {
        return this.datasource != null ? this.datasource : this.attribute;
    }

    @XmlAttribute(name="aggregation")
    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    @XmlAttribute(name="transient")
    public boolean getTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equal((Object)this.label, (Object)other.label) && Objects.equal((Object)this.resourceId, (Object)other.resourceId) && Objects.equal((Object)this.attribute, (Object)other.attribute) && Objects.equal((Object)this.datasource, (Object)other.datasource) && Objects.equal((Object)this.isTransient, (Object)other.isTransient);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.label, this.resourceId, this.attribute, this.datasource, this.isTransient});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Label", (Object)this.label).add("Resource ID", (Object)this.resourceId).add("Attribute", (Object)this.attribute).add("Datasource", (Object)this.datasource).add("Transient", this.isTransient).toString();
    }
}

