/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.model.Source;

public class Utils {
    public static Double toDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        return Double.valueOf(o.toString());
    }

    public static void convertStringAttributesToConstants(String sourceLabel, Map<String, String> stringAttributes, Map<String, Object> fetchResultConstants) {
        for (Map.Entry<String, String> propertyEntry : stringAttributes.entrySet()) {
            Object propertyValue;
            String propertyName = propertyEntry.getKey();
            try {
                propertyValue = Utils.toDouble(propertyEntry.getValue());
            }
            catch (Throwable t) {
                propertyValue = propertyEntry.getValue();
            }
            fetchResultConstants.put(String.format("%s.%s", sourceLabel, propertyName), propertyValue);
        }
    }

    public static void fillMissingValues(FetchResults fetchResults, List<Source> sources) {
        Objects.requireNonNull(fetchResults);
        Objects.requireNonNull(sources);
        int rowCount = fetchResults.getTimestamps().length;
        for (Source eachSource : sources) {
            if (fetchResults.getColumns().containsKey(eachSource.getLabel())) continue;
            fetchResults.getColumns().put(eachSource.getLabel(), Utils.createNaNArray(rowCount));
        }
    }

    private static double[] createNaNArray(int numberOfRows) {
        double[] values = new double[numberOfRows];
        for (int i = 0; i < numberOfRows; ++i) {
            values[i] = Double.NaN;
        }
        return values;
    }
}

