/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import java.util.Dictionary;
import java.util.Hashtable;
import org.opennms.features.kafka.producer.collection.CollectionSetMapper;
import org.opennms.features.kafka.producer.collection.KafkaPersister;
import org.opennms.features.kafka.producer.collection.KafkaPersisterFactory;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersisterActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersister.class);
    public static final String FORWARD_METRICS = "forward.metrics";
    public static final String PRODUCER_CONFIG = "org.opennms.features.kafka.producer";
    private static final String METRIC_TOPIC = "metricTopic";

    public void start(BundleContext context) throws Exception {
        ConfigurationAdmin configAdmin = null;
        Boolean forwardMetrics = false;
        String metricTopic = null;
        try {
            Dictionary properties;
            configAdmin = (ConfigurationAdmin)context.getService(context.getServiceReference(ConfigurationAdmin.class));
            if (configAdmin != null && (properties = configAdmin.getConfiguration(PRODUCER_CONFIG).getProperties()) != null && properties.get(FORWARD_METRICS) != null) {
                if (properties.get(FORWARD_METRICS) instanceof String) {
                    forwardMetrics = Boolean.parseBoolean((String)properties.get(FORWARD_METRICS));
                }
                if (properties.get(METRIC_TOPIC) instanceof String) {
                    metricTopic = (String)properties.get(METRIC_TOPIC);
                }
            }
        }
        catch (Exception e) {
            LOG.error(" Exception while loading configuration", (Throwable)e);
        }
        if (forwardMetrics.booleanValue()) {
            try {
                NodeDao nodeDao = (NodeDao)context.getService(context.getServiceReference(NodeDao.class));
                SessionUtils sessionUtils = (SessionUtils)context.getService(context.getServiceReference(SessionUtils.class));
                CollectionSetMapper collectionSetMapper = new CollectionSetMapper(nodeDao, sessionUtils);
                KafkaPersisterFactory kafkaPersisterFactory = new KafkaPersisterFactory();
                kafkaPersisterFactory.setCollectionSetMapper(collectionSetMapper);
                kafkaPersisterFactory.setConfigAdmin(configAdmin);
                kafkaPersisterFactory.init();
                kafkaPersisterFactory.setTopicName(metricTopic);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("strategy", "kafka");
                ((Dictionary)props).put("registration.export", "true");
                context.registerService(PersisterFactory.class, (Object)kafkaPersisterFactory, props);
                LOG.info("registered kafka persister factory to onms registry");
            }
            catch (Exception e) {
                LOG.error(" Exception while enabling kafka persister", (Throwable)e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

