/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import com.google.common.base.Strings;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.opennms.features.kafka.producer.collection.CollectionSetMapper;
import org.opennms.features.kafka.producer.model.CollectionSetProtos;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersister
implements Persister {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersister.class);
    private CollectionSetMapper collectionSetMapper;
    private KafkaProducer<String, byte[]> producer;
    private String topicName = "metrics";

    public void visitCollectionSet(CollectionSet collectionSet) {
        CollectionSetProtos.CollectionSet collectionSetProto = this.collectionSetMapper.buildCollectionSetProtos(collectionSet);
        String key = this.deriveKeyFromCollectionSet(collectionSetProto);
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)key, (Object)collectionSetProto.toByteArray());
        this.producer.send(record, (recordMetadata, e) -> {
            if (e != null) {
                LOG.warn("Failed to send record to producer: {}.", (Object)record, (Object)e);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("persisted collection {} to kafka with key {}", (Object)collectionSetProto.toString(), (Object)key);
            }
        });
    }

    private String deriveKeyFromCollectionSet(CollectionSetProtos.CollectionSet collectionSetProto) {
        String key = "";
        if (collectionSetProto.getResourceCount() > 0) {
            CollectionSetProtos.CollectionSetResource firstResource = collectionSetProto.getResource(0);
            if (firstResource.hasResponse()) {
                key = firstResource.getResponse().getInstance();
            } else if (firstResource.hasInterface()) {
                key = Long.toString(firstResource.getInterface().getNode().getNodeId());
            } else if (firstResource.hasGeneric()) {
                key = Long.toString(firstResource.getGeneric().getNode().getNodeId());
            } else if (firstResource.hasNode()) {
                key = Long.toString(firstResource.getNode().getNodeId());
            }
        }
        return key;
    }

    public void setTopicName(String topicName) {
        if (!Strings.isNullOrEmpty((String)topicName)) {
            this.topicName = topicName;
        }
    }

    public void setProducer(KafkaProducer<String, byte[]> producer) {
        this.producer = producer;
    }

    public void setCollectionSetMapper(CollectionSetMapper collectionSetMapper) {
        this.collectionSetMapper = collectionSetMapper;
    }

    public void visitResource(CollectionResource resource) {
    }

    public void visitGroup(AttributeGroup group) {
    }

    public void visitAttribute(CollectionAttribute attribute) {
    }

    public void completeAttribute(CollectionAttribute attribute) {
    }

    public void completeGroup(AttributeGroup group) {
    }

    public void completeResource(CollectionResource resource) {
    }

    public void completeCollectionSet(CollectionSet set) {
    }

    public void persistNumericAttribute(CollectionAttribute attribute) {
    }

    public void persistStringAttribute(CollectionAttribute attribute) {
    }
}

