/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer;

import com.google.common.base.Enums;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.kafka.producer.model.OpennmsModelProtos;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsHwEntityAlias;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufMapper.class);
    private final EventConfDao eventConfDao;
    private final SessionUtils sessionUtils;
    private final NodeDao nodeDao;
    private final HwEntityDao hwEntityDao;
    private final LoadingCache<Long, OpennmsModelProtos.NodeCriteria> nodeIdToCriteriaCache;

    public ProtobufMapper(EventConfDao eventConfDao, HwEntityDao hwEntityDao, final SessionUtils sessionUtils, final NodeDao nodeDao, long nodeIdToCriteriaMaxCacheSize) {
        this.eventConfDao = Objects.requireNonNull(eventConfDao);
        this.hwEntityDao = Objects.requireNonNull(hwEntityDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.nodeIdToCriteriaCache = CacheBuilder.newBuilder().maximumSize(nodeIdToCriteriaMaxCacheSize).build((CacheLoader)new CacheLoader<Long, OpennmsModelProtos.NodeCriteria>(){

            public OpennmsModelProtos.NodeCriteria load(Long nodeId) {
                return (OpennmsModelProtos.NodeCriteria)sessionUtils.withReadOnlyTransaction(() -> {
                    OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
                    if (node != null && node.getForeignId() != null && node.getForeignSource() != null) {
                        return OpennmsModelProtos.NodeCriteria.newBuilder().setId(nodeId).setForeignId(node.getForeignId()).setForeignSource(node.getForeignSource()).build();
                    }
                    return OpennmsModelProtos.NodeCriteria.newBuilder().setId(nodeId).build();
                });
            }
        });
    }

    public OpennmsModelProtos.Node.Builder toNode(OnmsNode node) {
        if (node == null) {
            return null;
        }
        OpennmsModelProtos.Node.Builder builder = OpennmsModelProtos.Node.newBuilder().setId(node.getId().intValue()).setLabel(node.getLabel()).setLocation(node.getLocation().getLocationName());
        if (node.getForeignSource() != null) {
            builder.setForeignSource(node.getForeignSource());
        }
        if (node.getForeignId() != null) {
            builder.setForeignId(node.getForeignId());
        }
        if (node.getSysContact() != null) {
            builder.setSysContact(node.getSysContact());
        }
        if (node.getSysDescription() != null) {
            builder.setSysDescription(node.getSysDescription());
        }
        if (node.getSysObjectId() != null) {
            builder.setSysObjectId(node.getSysObjectId());
        }
        node.getSnmpInterfaces().forEach(s -> builder.addSnmpInterface(this.toSnmpInterface((OnmsSnmpInterface)s)));
        node.getIpInterfaces().forEach(i -> builder.addIpInterface(this.toIpInterface((OnmsIpInterface)i)));
        node.getCategories().stream().map(OnmsCategory::getName).sorted().forEach(builder::addCategory);
        ProtobufMapper.setTimeIfNotNull(node.getCreateTime(), builder::setCreateTime);
        OnmsHwEntity rootEntity = this.hwEntityDao.findRootByNodeId(node.getId());
        if (rootEntity != null) {
            builder.setHwInventory(ProtobufMapper.toHwEntity(rootEntity));
        }
        return builder;
    }

    public static OpennmsModelProtos.HwEntity.Builder toHwEntity(OnmsHwEntity entity) {
        if (entity == null) {
            return null;
        }
        OpennmsModelProtos.HwEntity.Builder builder = OpennmsModelProtos.HwEntity.newBuilder();
        if (entity.getId() != null) {
            builder.setEntityId(entity.getId());
        }
        if (entity.getEntPhysicalIndex() != null) {
            builder.setEntPhysicalIndex(entity.getEntPhysicalIndex());
        }
        if (entity.getEntPhysicalClass() != null) {
            builder.setEntPhysicalClass(entity.getEntPhysicalClass());
        }
        if (entity.getEntPhysicalDescr() != null) {
            builder.setEntPhysicalDescr(entity.getEntPhysicalDescr());
        }
        if (entity.getEntPhysicalIsFRU() != null) {
            builder.setEntPhysicalIsFru(entity.getEntPhysicalIsFRU());
        }
        if (entity.getEntPhysicalName() != null) {
            builder.setEntPhysicalName(entity.getEntPhysicalName());
        }
        if (entity.getEntPhysicalVendorType() != null) {
            builder.setEntPhysicalVendorType(entity.getEntPhysicalVendorType());
        }
        entity.getEntAliases().stream().forEach(alias -> builder.addEntHwAlias(ProtobufMapper.toHwAlias(alias)));
        entity.getChildren().stream().forEach(child -> builder.addChildren(ProtobufMapper.toHwEntity(child)));
        return builder;
    }

    public static OpennmsModelProtos.HwAlias.Builder toHwAlias(OnmsHwEntityAlias alias) {
        if (alias == null) {
            return null;
        }
        OpennmsModelProtos.HwAlias.Builder builder = OpennmsModelProtos.HwAlias.newBuilder().setIndex(alias.getIndex()).setOid(alias.getOid());
        return builder;
    }

    public OpennmsModelProtos.Event.Builder toEvent(Event event) {
        if (event == null) {
            return null;
        }
        OpennmsModelProtos.Event.Builder builder = OpennmsModelProtos.Event.newBuilder().setId(event.getDbid().intValue()).setUei(event.getUei()).setSource(event.getSource()).setSeverity(this.toSeverity(OnmsSeverity.get((String)event.getSeverity()))).setLabel(this.eventConfDao.getEventLabel(event.getUei()));
        if (event.getDescr() != null) {
            builder.setDescription(event.getDescr());
        }
        if (event.getLogmsg() != null) {
            builder.setLogMessage(event.getLogmsg().getContent());
        }
        if (event.getNodeid() != null) {
            try {
                builder.setNodeCriteria((OpennmsModelProtos.NodeCriteria)this.nodeIdToCriteriaCache.get((Object)event.getNodeid()));
            }
            catch (ExecutionException e) {
                LOG.warn("An error occurred when building node criteria for node with id: {}. The node foreign source and foreign id (if set) will be missing from the event with id: {}.", new Object[]{event.getNodeid(), event.getDbid(), e});
                builder.setNodeCriteria(OpennmsModelProtos.NodeCriteria.newBuilder().setId(event.getNodeid()));
            }
            builder.setNodeCriteria(OpennmsModelProtos.NodeCriteria.newBuilder().setId(event.getNodeid()));
        }
        if (event.getInterface() != null) {
            builder.setIpAddress(event.getInterface());
        }
        ProtobufMapper.setTimeIfNotNull(event.getTime(), builder::setTime);
        return builder;
    }

    public OpennmsModelProtos.Event.Builder toEvent(OnmsEvent event) {
        if (event == null) {
            return null;
        }
        OpennmsModelProtos.Event.Builder builder = OpennmsModelProtos.Event.newBuilder().setId(event.getId().intValue()).setUei(event.getEventUei()).setSource(event.getEventSource()).setSeverity(this.toSeverity(OnmsSeverity.get((int)event.getEventSeverity()))).setLog("Y".equalsIgnoreCase(event.getEventLog())).setDisplay("Y".equalsIgnoreCase(event.getEventDisplay()));
        String eventLabel = this.eventConfDao.getEventLabel(event.getEventUei());
        if (eventLabel != null) {
            builder.setLabel(eventLabel);
        }
        if (event.getEventDescr() != null) {
            builder.setDescription(event.getEventDescr());
        }
        if (event.getEventLogMsg() != null) {
            builder.setLogMessage(event.getEventLogMsg());
        }
        if (event.getNodeId() != null) {
            builder.setNodeCriteria(this.toNodeCriteria(event.getNode()));
        }
        for (OnmsEventParameter param : event.getEventParameters()) {
            if (param.getName() == null || param.getValue() == null) continue;
            builder.addParameter(OpennmsModelProtos.EventParameter.newBuilder().setName(param.getName()).setValue(param.getValue()));
        }
        ProtobufMapper.setTimeIfNotNull(event.getEventTime(), builder::setTime);
        ProtobufMapper.setTimeIfNotNull(event.getEventCreateTime(), builder::setTime);
        return builder;
    }

    public OpennmsModelProtos.Alarm.Builder toAlarm(OnmsAlarm alarm) {
        OpennmsModelProtos.Alarm.Builder builder = OpennmsModelProtos.Alarm.newBuilder().setId(alarm.getId().intValue()).setUei(alarm.getUei()).setCount(alarm.getCounter().intValue()).setSeverity(this.toSeverity(alarm.getSeverity()));
        if (alarm.getReductionKey() != null) {
            builder.setReductionKey(alarm.getReductionKey());
        }
        if (this.toEvent(alarm.getLastEvent()) != null) {
            builder.setLastEvent(this.toEvent(alarm.getLastEvent()));
        }
        if (alarm.getLogMsg() != null) {
            builder.setLogMessage(alarm.getLogMsg());
        }
        if (alarm.getDescription() != null) {
            builder.setDescription(alarm.getDescription());
        }
        if (alarm.getIpAddr() != null) {
            builder.setIpAddress(InetAddressUtils.toIpAddrString((InetAddress)alarm.getIpAddr()));
        }
        if (alarm.getIfIndex() != null) {
            builder.setIfIndex(alarm.getIfIndex());
        }
        if (alarm.getOperInstruct() != null) {
            builder.setOperatorInstructions(alarm.getOperInstruct());
        }
        if (alarm.getAckUser() != null) {
            builder.setAckUser(alarm.getAckUser());
        }
        if (alarm.getClearKey() != null) {
            builder.setClearKey(alarm.getClearKey());
        }
        if (alarm.getNodeId() != null) {
            builder.setNodeCriteria(this.toNodeCriteria(alarm.getNode()));
        }
        if (alarm.getManagedObjectInstance() != null) {
            builder.setManagedObjectInstance(alarm.getManagedObjectInstance());
        }
        if (alarm.getManagedObjectType() != null) {
            builder.setManagedObjectType(alarm.getManagedObjectType());
        }
        if (alarm.getRelatedAlarms() != null) {
            alarm.getRelatedAlarms().forEach(relatedAlarm -> builder.addRelatedAlarm(this.toAlarm((OnmsAlarm)relatedAlarm)));
        }
        OpennmsModelProtos.Alarm.Type type = OpennmsModelProtos.Alarm.Type.UNRECOGNIZED;
        if (alarm.getAlarmType() != null) {
            if (alarm.getAlarmType() == 1) {
                type = OpennmsModelProtos.Alarm.Type.PROBLEM_WITH_CLEAR;
            } else if (alarm.getAlarmType() == 2) {
                type = OpennmsModelProtos.Alarm.Type.CLEAR;
            } else if (alarm.getAlarmType() == 3) {
                type = OpennmsModelProtos.Alarm.Type.PROBLEM_WITHOUT_CLEAR;
            }
        }
        builder.setType(type);
        if (alarm.getServiceType() != null) {
            builder.setServiceName(alarm.getServiceType().getName());
        }
        ProtobufMapper.setTimeIfNotNull(alarm.getFirstEventTime(), builder::setFirstEventTime);
        ProtobufMapper.setTimeIfNotNull(alarm.getLastEventTime(), builder::setLastEventTime);
        ProtobufMapper.setTimeIfNotNull(alarm.getAckTime(), builder::setAckTime);
        return builder;
    }

    public OpennmsModelProtos.AlarmFeedback.Builder toAlarmFeedback(AlarmFeedback alarmFeedback) {
        return OpennmsModelProtos.AlarmFeedback.newBuilder().setSituationKey(alarmFeedback.getSituationKey()).setSituationFingerprint(alarmFeedback.getSituationFingerprint()).setAlarmKey(alarmFeedback.getAlarmKey()).setFeedbackType(OpennmsModelProtos.AlarmFeedback.FeedbackType.valueOf(alarmFeedback.getFeedbackType().toString())).setReason(alarmFeedback.getReason()).setUser(alarmFeedback.getUser()).setTimestamp(alarmFeedback.getTimestamp());
    }

    public OpennmsModelProtos.NodeCriteria.Builder toNodeCriteria(OnmsNode node) {
        OpennmsModelProtos.NodeCriteria.Builder builder = OpennmsModelProtos.NodeCriteria.newBuilder().setId(node.getId().intValue());
        if (node.getForeignSource() != null) {
            builder.setForeignSource(node.getForeignSource());
        }
        if (node.getForeignId() != null) {
            builder.setForeignId(node.getForeignId());
        }
        return builder;
    }

    public OpennmsModelProtos.Severity toSeverity(OnmsSeverity sev) {
        OpennmsModelProtos.Severity severity;
        switch (sev) {
            case INDETERMINATE: {
                severity = OpennmsModelProtos.Severity.INDETERMINATE;
                break;
            }
            case CLEARED: {
                severity = OpennmsModelProtos.Severity.CLEARED;
                break;
            }
            case NORMAL: {
                severity = OpennmsModelProtos.Severity.NORMAL;
                break;
            }
            case WARNING: {
                severity = OpennmsModelProtos.Severity.WARNING;
                break;
            }
            case MINOR: {
                severity = OpennmsModelProtos.Severity.MINOR;
                break;
            }
            case MAJOR: {
                severity = OpennmsModelProtos.Severity.MAJOR;
                break;
            }
            case CRITICAL: {
                severity = OpennmsModelProtos.Severity.CRITICAL;
                break;
            }
            default: {
                severity = OpennmsModelProtos.Severity.UNRECOGNIZED;
            }
        }
        return severity;
    }

    public OpennmsModelProtos.IpInterface.Builder toIpInterface(OnmsIpInterface ipInterface) {
        PrimaryType primaryType;
        if (ipInterface == null) {
            return null;
        }
        OpennmsModelProtos.IpInterface.Builder builder = OpennmsModelProtos.IpInterface.newBuilder().setId(ipInterface.getId().intValue()).setIpAddress(InetAddressUtils.toIpAddrString((InetAddress)ipInterface.getIpAddress()));
        OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
        if (snmpInterface != null && snmpInterface.getIfIndex() != null) {
            builder.setIfIndex(snmpInterface.getIfIndex());
        }
        if (PrimaryType.PRIMARY.equals((Object)(primaryType = ipInterface.getIsSnmpPrimary()))) {
            builder.setPrimaryType(OpennmsModelProtos.IpInterface.PrimaryType.PRIMARY);
        } else if (PrimaryType.SECONDARY.equals((Object)primaryType)) {
            builder.setPrimaryType(OpennmsModelProtos.IpInterface.PrimaryType.SECONDARY);
        } else if (PrimaryType.NOT_ELIGIBLE.equals((Object)primaryType)) {
            builder.setPrimaryType(OpennmsModelProtos.IpInterface.PrimaryType.NOT_ELIGIBLE);
        }
        ipInterface.getMonitoredServices().forEach(svc -> builder.addService(svc.getServiceName()));
        return builder;
    }

    public OpennmsModelProtos.SnmpInterface.Builder toSnmpInterface(OnmsSnmpInterface snmpInterface) {
        if (snmpInterface == null) {
            return null;
        }
        OpennmsModelProtos.SnmpInterface.Builder builder = OpennmsModelProtos.SnmpInterface.newBuilder().setId(snmpInterface.getId().intValue()).setIfIndex(snmpInterface.getIfIndex());
        if (snmpInterface.getIfDescr() != null) {
            builder.setIfDescr(snmpInterface.getIfDescr());
        }
        if (snmpInterface.getIfType() != null) {
            builder.setIfType(snmpInterface.getIfType());
        }
        if (snmpInterface.getIfName() != null) {
            builder.setIfName(snmpInterface.getIfName());
        }
        if (snmpInterface.getIfSpeed() != null) {
            builder.setIfSpeed(snmpInterface.getIfSpeed());
        }
        if (snmpInterface.getPhysAddr() != null) {
            builder.setIfPhysAddress(snmpInterface.getPhysAddr());
        }
        if (snmpInterface.getIfAdminStatus() != null) {
            builder.setIfAdminStatus(snmpInterface.getIfAdminStatus());
        }
        if (snmpInterface.getIfOperStatus() != null) {
            builder.setIfOperStatus(snmpInterface.getIfOperStatus());
        }
        if (snmpInterface.getIfAlias() != null) {
            builder.setIfAlias(snmpInterface.getIfAlias());
        }
        return builder;
    }

    private static void setTimeIfNotNull(Date date, Consumer<Long> setter) {
        if (date != null) {
            setter.accept(date.getTime());
        }
    }

    public OpennmsModelProtos.TopologyRef.Builder toTopologyRef(OnmsTopologyProtocol protocol, String id) {
        return OpennmsModelProtos.TopologyRef.newBuilder().setId(id).setProtocol((OpennmsModelProtos.TopologyRef.Protocol)((Object)Enums.getIfPresent(OpennmsModelProtos.TopologyRef.Protocol.class, (String)protocol.getId()).orNull()));
    }

    private OpennmsModelProtos.TopologyRef getTopologyRef(OnmsTopologyProtocol protocol, String id) {
        return this.toTopologyRef(protocol, id).build();
    }

    private OpennmsModelProtos.TopologyPort getPort(OnmsTopologyPort port) {
        OpennmsModelProtos.TopologyPort.Builder builder = OpennmsModelProtos.TopologyPort.newBuilder();
        if (port.getVertex().getId() != null) {
            builder.setVertexId(port.getVertex().getId());
        }
        if (port.getIfindex() != null) {
            builder.setIfIndex(port.getIfindex().intValue());
        }
        try {
            builder.setNodeCriteria((OpennmsModelProtos.NodeCriteria)this.nodeIdToCriteriaCache.get((Object)Integer.toUnsignedLong(port.getVertex().getNodeid())));
        }
        catch (CacheLoader.InvalidCacheLoadException | ExecutionException e) {
            LOG.warn("An error occurred when building node criteria for node with id: {}. The node foreign source and foreign id (if set) will be missing from the vertex with id: {}.", new Object[]{port.getVertex().getNodeid(), port.getVertex().getId(), e});
            builder.setNodeCriteria(OpennmsModelProtos.NodeCriteria.newBuilder().setId(port.getVertex().getNodeid().intValue()));
        }
        if (port.getIfname() != null) {
            builder.setIfName(port.getIfname());
        }
        if (port.getAddr() != null) {
            builder.setAddress(port.getAddr());
        }
        return builder.build();
    }

    private OpennmsModelProtos.TopologySegment getSegment(OnmsTopologyPort port, OnmsTopologyProtocol protocol) {
        return OpennmsModelProtos.TopologySegment.newBuilder().setRef(this.getTopologyRef(protocol, port.getId())).build();
    }

    private OpennmsModelProtos.Node getNode(OnmsTopologyPort port) {
        OpennmsModelProtos.Node.Builder nodeBuilder = OpennmsModelProtos.Node.newBuilder();
        if (port.getVertex().getNodeid() != null) {
            nodeBuilder.setId(port.getVertex().getNodeid().intValue());
        }
        try {
            OpennmsModelProtos.NodeCriteria nodeCriteria = (OpennmsModelProtos.NodeCriteria)this.nodeIdToCriteriaCache.get((Object)Integer.toUnsignedLong(port.getVertex().getNodeid()));
            if (nodeCriteria != null) {
                nodeBuilder.setForeignSource(nodeCriteria.getForeignSource());
                nodeBuilder.setForeignId(nodeCriteria.getForeignId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeBuilder.build();
    }

    public OpennmsModelProtos.TopologyEdge toEdgeTopologyMessage(OnmsTopologyProtocol protocol, OnmsTopologyEdge edge) {
        OpennmsModelProtos.TopologyEdge.Builder edgeBuilder = OpennmsModelProtos.TopologyEdge.newBuilder();
        edgeBuilder.setRef(this.getTopologyRef(protocol, edge.getId()));
        if (edge.getSource().getVertex().getNodeid() == null) {
            edgeBuilder.setSourceSegment(this.getSegment(edge.getSource(), protocol));
        } else if (edge.getSource().getIfindex() != null && edge.getSource().getIfindex() >= 0) {
            edgeBuilder.setSourcePort(this.getPort(edge.getSource()));
        } else {
            edgeBuilder.setSourceNode(this.getNode(edge.getSource()));
        }
        if (edge.getTarget().getVertex().getNodeid() == null) {
            edgeBuilder.setTargetSegment(this.getSegment(edge.getTarget(), protocol));
        } else if (edge.getTarget().getIfindex() != null && edge.getTarget().getIfindex() >= 0) {
            edgeBuilder.setTargetPort(this.getPort(edge.getTarget()));
        } else {
            edgeBuilder.setTargetNode(this.getNode(edge.getTarget()));
        }
        return edgeBuilder.build();
    }
}

