/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

public class NodeCache {
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;
    private final Map<Long, Long> lastUpdatedByNodeId = Maps.newHashMap();
    private long timeoutInMs = TimeUnit.MINUTES.toMillis(5L);

    public NodeCache(NodeDao nodeDao, SessionUtils sessionUtils) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public synchronized void triggerIfNeeded(long nodeId, Consumer<OnmsNode> consumer) {
        long now = System.currentTimeMillis();
        Long lastUpdated = this.lastUpdatedByNodeId.get(nodeId);
        if (lastUpdated != null && now - lastUpdated <= this.timeoutInMs) {
            return;
        }
        this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf((int)nodeId));
            this.lastUpdatedByNodeId.put(nodeId, now);
            consumer.accept(node);
            return null;
        });
    }

    public void setTimeoutInMs(long timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }
}

