/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.shell;

import java.io.Serializable;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.transaction.support.TransactionOperations;

@Command(scope="kafka-producer", name="evaluate-filter", description="Compiles the given expression and optionally test it against an object.")
@Service
public class EvaluateFilter
implements Action {
    private static final ExpressionParser SPEL_PARSER = new SpelExpressionParser();
    @Reference
    private AlarmDao alarmDao;
    @Reference
    private TransactionOperations transactionOperations;
    @Option(name="-a", aliases={"--alarm-id"}, description="Lookup an alarm by id and apply the given expression against it.")
    private Integer alarmId;
    @Option(name="-e", aliases={"--event-uei"}, description="Create a new event with the given UEI and apply the given expression against it.")
    private String eventUei;
    @Argument(description="An SPEL expression.")
    private String spelExpression;

    public Object execute() {
        Expression expression = SPEL_PARSER.parseExpression(this.spelExpression);
        System.out.printf("SPEL Expression: %s\n", expression.getExpressionString());
        if (this.alarmId != null) {
            this.transactionOperations.execute(status -> {
                if (this.alarmId != null) {
                    OnmsAlarm alarm = (OnmsAlarm)this.alarmDao.get((Serializable)this.alarmId);
                    if (alarm == null) {
                        System.out.printf("No alarm found with ID: %d\n", this.alarmId);
                    } else {
                        System.out.printf("Alarm with ID %d has reduction key: %s\n", this.alarmId, alarm.getReductionKey());
                    }
                    System.out.printf("Result: %s\n", expression.getValue((Object)alarm, Boolean.class));
                }
                return null;
            });
        }
        if (this.eventUei != null) {
            Event event = new EventBuilder(this.eventUei, "kafka-producer:evaluate-filter").getEvent();
            System.out.printf("Event has UEI: %s\n", event.getUei());
            System.out.printf("Result: %s\n", expression.getValue((Object)event, Boolean.class));
        }
        return null;
    }
}

