/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.shell;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.kafka.producer.datasync.AlarmDataStore;
import org.opennms.features.kafka.producer.datasync.AlarmSyncResults;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.springframework.transaction.support.TransactionOperations;

@Command(scope="kafka-producer", name="sync-alarms", description="Triggers a syncrhonization of the alarms topic against the database.")
@Service
public class SyncAlarms
implements Action {
    @Reference
    private AlarmDataStore alarmDataStore;
    @Reference
    private TransactionOperations transactionOperations;
    @Reference
    private AlarmDao alarmDao;

    public Object execute() {
        if (!SyncAlarms.waitForAlarmDataStore(this.alarmDataStore)) {
            return null;
        }
        return this.transactionOperations.execute(status -> {
            List alarmsInDb = this.alarmDao.findAll();
            System.out.println("Performing synchronization of alarms from the database with those in the ktable.");
            long start = System.currentTimeMillis();
            AlarmSyncResults results = this.alarmDataStore.handleAlarmSnapshot(alarmsInDb);
            long delay = System.currentTimeMillis() - start;
            System.out.printf("Executed %d updates in %dms.\n\n", results.getNumUpdates(), delay);
            System.out.printf("Number of reduction keys in ktable: %d\n", results.getAlarmsInKtableByReductionKey().size());
            System.out.printf("Number of reduction keys in the db: %d (%d alarms total)\n", results.getAlarmsInDbByReductionKey().size(), results.getAlarmsInDb().size());
            if (results.getNumUpdates() > 0) {
                System.out.print("Reduction keys added to the ktable:");
                SyncAlarms.printSet(results.getReductionKeysAdded());
                System.out.print("Reduction keys deleted from the ktable:");
                SyncAlarms.printSet(results.getReductionKeysDeleted());
                System.out.print("Reduction keys updated in the ktable:");
                SyncAlarms.printSet(results.getReductionKeysUpdated());
            }
            return null;
        });
    }

    protected static boolean waitForAlarmDataStore(AlarmDataStore alarmDataStore) {
        if (!alarmDataStore.isEnabled()) {
            System.out.println("The alarm data store is currently disabled and must be enabled for this shell command to function.");
            return false;
        }
        if (!SyncAlarms.isAlarmDataStoreReady(alarmDataStore)) {
            long startTime = System.currentTimeMillis();
            System.out.println("Waiting for alarm data store to be ready..");
            try {
                do {
                    System.out.print(".");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                } while (!SyncAlarms.isAlarmDataStoreReady(alarmDataStore));
                System.out.printf("\nReady in %d ms.\n\n", System.currentTimeMillis() - startTime);
            }
            catch (InterruptedException e) {
                System.out.println("\nInterrupted.");
                return false;
            }
        }
        return true;
    }

    private static boolean isAlarmDataStoreReady(AlarmDataStore alarmDataStore) {
        try {
            return alarmDataStore.isReady();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void printSet(Set<String> reductionKeys) {
        if (reductionKeys.size() < 1) {
            System.out.println(" (None)");
        } else {
            System.out.println();
            reductionKeys.forEach(rkey -> System.out.printf("\t%s\n", rkey));
        }
    }
}

