/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.features.kafka.producer.collection.CollectionSetMapper;
import org.opennms.features.kafka.producer.collection.KafkaPersister;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersisterFactory
implements PersisterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersisterFactory.class);
    private CollectionSetMapper collectionSetMapper;
    private KafkaProducer<String, byte[]> producer;
    private ConfigurationAdmin configAdmin;
    private String topicName;

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        return this.createPersister(params, repository);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        KafkaPersister persister = new KafkaPersister();
        persister.setCollectionSetMapper(this.collectionSetMapper);
        persister.setProducer(this.producer);
        persister.setTopicName(this.topicName);
        return persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        Properties producerConfig = new Properties();
        Dictionary properties = this.configAdmin.getConfiguration("org.opennms.features.kafka.producer.client").getProperties();
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                producerConfig.put(key, properties.get(key));
            }
        }
        producerConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
        producerConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            this.producer = new KafkaProducer(producerConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        LOG.info(" kafka producer initialized with {} ", (Object)producerConfig);
    }

    public void destroy() {
        if (this.producer != null) {
            LOG.info(" close kafka producer");
            this.producer.close();
            this.producer = null;
        }
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setCollectionSetMapper(CollectionSetMapper collectionSetMapper) {
        this.collectionSetMapper = collectionSetMapper;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}

