/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.log;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogAdapter
implements LogAdapter {
    private final Logger logger;

    public Slf4jLogAdapter(Class clazz) {
        this.logger = LoggerFactory.getLogger((Class)clazz);
    }

    @Override
    public void warn(String warnMessage, Object ... args) {
        this.logger.warn(warnMessage, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.logger.error(message, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.logger.debug(message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.logger.info(message, args);
    }

    @Override
    public void info(InputStream inputStream) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)out);
            this.info(out.toString(), new Object[0]);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }
}

