/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.graphs;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.opennms.features.jmxconfiggenerator.graphs.Colors;
import org.opennms.features.jmxconfiggenerator.graphs.Graph;
import org.opennms.features.jmxconfiggenerator.graphs.Report;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class JmxConfigReader {
    private static final String ATTRIBUTEREPORT = "AttributeReport";
    private static final String MBEANREPORT = "MBeanReport";
    private static final String COMPOSITEREPORT = "CompositeReport";
    private static final String COMPOSITATTRIBEREPORT = "CompositeAttributeReport";
    private final LogAdapter logger;

    public JmxConfigReader(LogAdapter logger) {
        this.logger = logger;
    }

    protected Collection<Report> generateReportsByJmxDatacollectionConfig(InputStream inputConfigStream) {
        return this.generateReportsByJmxDatacollectionConfig((JmxDatacollectionConfig)JAXB.unmarshal((InputStream)inputConfigStream, JmxDatacollectionConfig.class));
    }

    public Collection<Report> generateReportsByJmxDatacollectionConfig(String inputConfigFileName) {
        return this.generateReportsByJmxDatacollectionConfig((JmxDatacollectionConfig)JAXB.unmarshal((File)new File(inputConfigFileName), JmxDatacollectionConfig.class));
    }

    public Collection<Report> generateReportsByJmxDatacollectionConfig(JmxDatacollectionConfig inputConfig) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (JmxCollection jmxCollection : inputConfig.getJmxCollection()) {
            this.logger.debug("jmxCollection: '{}'", jmxCollection.getName());
            for (Mbean mbean : jmxCollection.getMbeans().getMbean()) {
                reports.addAll(this.generateMbeanReportsByMBean(mbean));
                reports.addAll(this.generateAttributeReportsByMBean(mbean));
                reports.addAll(this.generateCompositeReportsByMBean(mbean));
                reports.addAll(this.generateCompositeMemberReportsByMBean(mbean));
            }
        }
        return reports;
    }

    private Collection<Report> generateAttributeReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Attrib attrib : mbean.getAttrib()) {
            String title = String.format("%s[%s]", mbean.getObjectname().toString(), attrib.getName());
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + attrib.getAlias() + "." + ATTRIBUTEREPORT;
            Report report = new Report(reportId, title, title, "verticalLabel");
            report.addGraph(new Graph(attrib.getAlias(), attrib.getName(), attrib.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            reports.add(report);
            Colors.resetColor();
        }
        return reports;
    }

    private Collection<Report> generateMbeanReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        if (!mbean.getAttrib().isEmpty()) {
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + MBEANREPORT;
            Report report = new Report(reportId, mbean.getName(), mbean.getName(), "verticalLabel");
            for (Attrib attrib : mbean.getAttrib()) {
                report.addGraph(new Graph(attrib.getAlias(), attrib.getName(), attrib.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            }
            reports.add(report);
            Colors.resetColor();
        }
        return reports;
    }

    private Collection<Report> generateCompositeReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (CompAttrib compAttrib : mbean.getCompAttrib()) {
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + compAttrib.getName() + "." + COMPOSITEREPORT;
            Report report = new Report(reportId, reportId, reportId, "verticalLabel");
            for (CompMember compMember : compAttrib.getCompMember()) {
                report.addGraph(new Graph(compMember.getAlias(), compMember.getName(), compMember.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            }
            reports.add(report);
            Colors.resetColor();
        }
        return reports;
    }

    private Collection<Report> generateCompositeMemberReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (CompAttrib compAttrib : mbean.getCompAttrib()) {
            for (CompMember compMember : compAttrib.getCompMember()) {
                String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + compAttrib.getName() + "." + compMember.getName() + "." + COMPOSITATTRIBEREPORT;
                Report report = new Report(reportId, reportId, reportId, "verticalLabel");
                report.addGraph(new Graph(compMember.getAlias(), compMember.getName(), compMember.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
                reports.add(report);
                Colors.resetColor();
            }
        }
        return reports;
    }
}

