/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.jmxconfig;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxHelper {
    public static JMXServiceURL createJmxServiceUrl(String url, String hostName, String port, boolean jmxmp) throws MalformedURLException {
        if (url != null) {
            return new JMXServiceURL(url);
        }
        if (hostName != null && port != null) {
            if (jmxmp) {
                return new JMXServiceURL(String.format("service:jmx:jmxmp://%s:%s", hostName, port));
            }
            return new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", hostName, port));
        }
        throw new IllegalStateException("Something went wrong. Was not able to determine JMX Connection URL.");
    }

    public static JMXConnector createJmxConnector(String username, String password, JMXServiceURL serviceUrl) throws IOException {
        Objects.requireNonNull(serviceUrl, "You must specify a JMXServiceURL in order to create a JMXConnector.");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (username != null && password != null) {
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
        }
        JMXConnector jmxConnector = JMXConnectorFactory.connect(serviceUrl, env);
        return jmxConnector;
    }

    public static Map<String, String> loadInternalDictionary() throws IOException {
        HashMap<String, String> internalDictionary = new HashMap<String, String>();
        Properties properties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(JmxHelper.class.getResourceAsStream("/dictionary.properties"));){
            properties.load(stream);
        }
        catch (IOException ex) {
            throw new IOException("Load dictionary entries from internal properties files error: '" + ex.getMessage() + "'", ex);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            internalDictionary.put(key.toString(), value == null ? null : value.toString());
        }
        return internalDictionary;
    }
}

