/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.commands.CmdRunException;
import org.opennms.features.jmxconfiggenerator.commands.Command;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxHelper;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;

public abstract class JmxCommand
extends Command {
    @Option(name="--host", usage="Hostname or IP-Address of JMX-RMI host.", forbids={"--url"}, metaVar="<host>")
    private String hostName;
    @Option(name="--port", usage="Port of JMX-RMI service", forbids={"--url"}, metaVar="<port>")
    private String port;
    @Option(name="--username", usage="Username for JMX-RMI Authentication", metaVar="<username>")
    private String username;
    @Option(name="--password", usage="Password for JMX-RMI Authentication", metaVar="<password>")
    private String password;
    @Option(name="--jmxmp", usage="Use JMXMP and not JMX-RMI")
    private boolean jmxmp;
    @Option(name="--url", usage="JMX URL Usage: <hostname>:<port> OR service:jmx:<protocol>:<sap> OR service:jmx:remoting-jmx://<hostname>:<port>", forbids={"--host", "--port"}, metaVar="<url>")
    private String url;

    @Override
    protected void validate(CmdLineParser parser) throws CmdLineException {
        if (this.url != null && (this.hostName != null || this.port != null)) {
            this.LOG.warn("WARNING: You have defined an url and a hostname and/or port. Using url '{}' and ignoring hostname:port", this.url);
        }
        if (this.url == null && (this.hostName == null || this.port == null)) {
            throw new CmdLineException(parser, "You have to define either an url or an hostname and port to connect to a jmx server.");
        }
    }

    @Override
    protected void execute() throws CmdLineException, CmdRunException {
        try (JMXConnector connector = this.getJmxConnector();){
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            this.execute(mbeanServerConnection);
        }
        catch (IOException | JMException | MBeanServerQueryException e) {
            throw new CmdRunException(e);
        }
    }

    private JMXServiceURL getJmxServiceURL() throws MalformedURLException {
        return JmxHelper.createJmxServiceUrl(this.url, this.hostName, this.port, this.jmxmp);
    }

    private JMXConnector getJmxConnector() throws IOException {
        return JmxHelper.createJmxConnector(this.username, this.password, this.getJmxServiceURL());
    }

    protected abstract void execute(MBeanServerConnection var1) throws MBeanServerQueryException, IOException, JMException;
}

