/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.jmxconfiggenerator.graphs.Report;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxDatacollectionConfiggenerator;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    private static Logger logger = LoggerFactory.getLogger(Starter.class);
    @Option(name="-jmx", usage="Generate jmx-datacollection.xml by reading JMX over RMI")
    private boolean jmx = false;
    @Option(name="-service", usage="Your optional service-name. Like cassandra, jboss, tomcat")
    private String serviceName = "anyservice";
    @Option(name="-host", usage="Hostname or IP-Adress of JMX-RMI host")
    private String hostName;
    @Option(name="-username", usage="Username for JMX-RMI Authentication")
    private String username;
    @Option(name="-password", usage="Password for JMX-RMI Authentication")
    private String password;
    @Option(name="-port", usage="Port of JMX-RMI service")
    private String port;
    @Option(name="-jmxmp", usage="Use JMXMP and not JMX-RMI")
    private boolean jmxmp = false;
    private boolean ssl = false;
    @Option(name="-skipDefaultVM", usage="set to process default JavaVM Beans.")
    private boolean skipDefaultVM = false;
    @Option(name="-runWritableMBeans", usage="include MBeans that are read- and writable.")
    private boolean runWritableMBeans = false;
    @Option(name="-graph", usage="Generate snmp-graph.properties linke file to out, by reading jmx-datacollection.xml like file from input")
    private boolean graph = false;
    @Option(name="-input", usage="Jmx-datacolletion.xml like file to parse")
    private String inputFile;
    @Option(name="-out", usage="File to write generated snmp-graph.properties linke content")
    private String outFile;
    @Option(name="-template", usage="Template file for SnmpGraphs")
    private String templateFile;
    @Option(name="-dictionary", usage="Dictionary properties file for replacing attribute names and parts of this names")
    private String dictionaryFile;
    @Option(name="-url", usage="JMX URL Usage: <hostname>:<port> OR service:jmx:<protocol>:<sap> OR service:jmx:remoting-jmx://<hostname>:<port>")
    private String url;

    public static void main(String[] args) throws IOException {
        new Starter().doMain(args);
    }

    public void doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
            if (this.jmx && this.graph) {
                throw new CmdLineException(parser, "jmx and graph is set. Just use one at a time.");
            }
            if (!this.jmx && !this.graph) {
                throw new CmdLineException(parser, "set jmx or graph.");
            }
            Map<String, String> dictionary = Starter.loadInternalDictionary();
            if (this.dictionaryFile != null) {
                dictionary = this.loadExternalDictionary(this.dictionaryFile);
            }
            if (this.jmx) {
                JMXConnector jmxConnector = null;
                JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator();
                JMXServiceURL jmxServiceURL = null;
                if (this.hostName != null && this.port != null && this.outFile != null) {
                    jmxServiceURL = jmxConfigGenerator.getJmxServiceURL(this.jmxmp, this.hostName, this.port);
                } else if (this.url != null && this.outFile != null) {
                    jmxServiceURL = new JMXServiceURL(this.url);
                } else {
                    throw new CmdLineException(parser, "no valid call found.");
                }
                jmxConnector = jmxConfigGenerator.getJmxConnector(this.username, this.password, jmxServiceURL);
                MBeanServerConnection mBeanServerConnection = jmxConfigGenerator.createMBeanServerConnection(jmxConnector);
                JmxDatacollectionConfig generateJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(mBeanServerConnection, this.serviceName, !this.skipDefaultVM, this.runWritableMBeans, dictionary);
                jmxConfigGenerator.writeJmxConfigFile(generateJmxConfigModel, this.outFile);
                if (jmxConnector != null) {
                    logger.debug("closing connection");
                    jmxConnector.close();
                    logger.debug("connection closed");
                }
                return;
            }
            if (this.graph) {
                if (this.inputFile != null && this.outFile != null) {
                    JmxConfigReader jmxToSnmpGraphConfigGen = new JmxConfigReader();
                    Collection<Report> reports = jmxToSnmpGraphConfigGen.generateReportsByJmxDatacollectionConfig(this.inputFile);
                    GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator();
                    String snmpGraphConfig = this.templateFile != null ? graphConfigGenerator.generateSnmpGraph(reports, this.templateFile) : graphConfigGenerator.generateSnmpGraph(reports);
                    System.out.println(snmpGraphConfig);
                    FileUtils.writeStringToFile((File)new File(this.outFile), (String)snmpGraphConfig, (String)"UTF-8");
                    return;
                }
                throw new CmdLineException(parser, "no valid call found.");
            }
            throw new CmdLineException(parser, "no valid call found.");
        }
        catch (Exception e) {
            logger.error("An exception occured", (Throwable)e);
            System.err.println("JmxConfigGenerator [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            System.err.println("Examples:");
            System.err.println(" Generation of jmx-datacollection.xml: java -jar JmxConfigGenerator.jar -jmx -host localhost -port 7199 -out JMX-DatacollectionDummy.xml [-service cassandra] [-skipDefaultVM] [-runWritableMBeans] [-dictionary dictionary.properties]");
            System.err.println(" Generation of snmp-graph.properties: java -jar JmxConfigGenerator.jar -graph -input test.xml -out test.properies [-template graphTemplate.vm] [-service cassandra]");
            return;
        }
    }

    public static Map<String, String> loadInternalDictionary() {
        HashMap<String, String> internalDictionary = new HashMap<String, String>();
        Properties properties = new Properties();
        try {
            BufferedInputStream stream = new BufferedInputStream(Starter.class.getClassLoader().getResourceAsStream("dictionary.properties"));
            properties.load(stream);
            stream.close();
        }
        catch (IOException ex) {
            logger.error("Load dictionary entries from internal properties files error: '{}'", (Object)ex.getMessage());
        }
        logger.info("Loaded '{}' internal dictionary entries", (Object)properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            internalDictionary.put(key.toString(), value == null ? null : value.toString());
        }
        logger.info("Dictionary entries loaded: '{}'", (Object)internalDictionary.size());
        return internalDictionary;
    }

    private Map<String, String> loadExternalDictionary(String dictionaryFile) {
        HashMap<String, String> externalDictionary = new HashMap<String, String>();
        Properties properties = new Properties();
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(dictionaryFile));
            properties.load(stream);
            stream.close();
        }
        catch (FileNotFoundException ex) {
            logger.error("'{}'", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("'{}'", (Object)ex.getMessage());
        }
        logger.info("Loaded '{}' external dictionary entries from '{}'", (Object)properties.size(), (Object)dictionaryFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            externalDictionary.put(key.toString(), value == null ? null : value.toString());
        }
        logger.info("Dictionary entries loaded: '{}'", (Object)externalDictionary.size());
        return externalDictionary;
    }
}

