/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormFieldFactory;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.EditControls;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.FormParameter;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedListener;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.NameValidator;

public class NameEditForm
extends Form
implements ModelChangeListener<Item>,
ViewStateChangedListener,
EditControls.Callback<Component> {
    private final EditControls<Component> footer = new EditControls(this);
    private final MBeansController controller;
    private final Validator nameValidator = new NameValidator();
    private final FormParameter parameter;

    public NameEditForm(MBeansController controller, final FormParameter parameter) {
        this.controller = controller;
        this.parameter = parameter;
        this.setFormFieldFactory(new FormFieldFactory(){

            public Field<?> createField(Item item, Object propertyId, Component uiContext) {
                if (propertyId.toString().equals("selected")) {
                    CheckBox c = new CheckBox("selected");
                    return c;
                }
                if (propertyId.toString().equals(parameter.getNonEditablePropertyName())) {
                    TextField tf = new TextField(parameter.getNonEditablePropertyName()){

                        public void setReadOnly(boolean readOnly) {
                            super.setReadOnly(true);
                        }
                    };
                    tf.setWidth(100.0f, Sizeable.UNITS_PERCENTAGE);
                    return tf;
                }
                if (propertyId.toString().equals(parameter.getEditablePropertyName())) {
                    TextField tf = new TextField(parameter.getEditablePropertyName());
                    tf.setWidth(100.0f, Sizeable.UNITS_PERCENTAGE);
                    tf.setValidationVisible(true);
                    tf.setRequired(true);
                    tf.setRequiredError("You must provide a name.");
                    tf.addValidator(NameEditForm.this.nameValidator);
                    return tf;
                }
                return null;
            }
        });
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setHeight(170 + (parameter.hasFooter() ? 0 : -60), Sizeable.Unit.PIXELS);
        this.setReadOnly(true);
        this.setImmediate(true);
        this.setBuffered(true);
        if (parameter.hasFooter()) {
            this.setFooter((Layout)this.footer);
        }
        this.addFooterHooks();
        this.setCaption(parameter.getCaption());
        this.setVisibleItemProperties(parameter.getVisiblePropertieNames());
    }

    @Override
    public void modelChanged(Item newItem) {
        this.setItemDataSource(newItem);
        this.setVisibleItemProperties(this.getVisibleItemProperties());
    }

    @Override
    public void viewStateChanged(ViewStateChangedEvent event) {
        switch (event.getNewState()) {
            case Init: 
            case NonLeafSelected: {
                this.modelChanged(null);
            }
            case Edit: {
                this.setEnabled(event.getSource() == this);
                this.getFooter().setVisible(event.getSource() == this);
                break;
            }
            case LeafSelected: {
                this.setReadOnly(true);
                this.setEnabled(true);
                this.getFooter().setVisible(true);
            }
        }
    }

    private void addFooterHooks() {
        this.footer.addCancelHook(this);
        this.footer.addEditHook(this);
        this.footer.addSaveHook(this);
    }

    @Override
    public void callback(EditControls.ButtonType type, Component outer) {
        if (type == EditControls.ButtonType.cancel) {
            this.controller.fireViewStateChanged(ViewState.LeafSelected, this);
            this.callAdditionalCallbacksIfThereAreAny(type, outer);
        }
        if (type == EditControls.ButtonType.edit) {
            this.controller.fireViewStateChanged(ViewState.Edit, this);
            this.callAdditionalCallbacksIfThereAreAny(type, outer);
        }
        if (type == EditControls.ButtonType.save) {
            if (this.isValid()) {
                this.commit();
                this.controller.fireViewStateChanged(ViewState.LeafSelected, this);
                this.callAdditionalCallbacksIfThereAreAny(type, outer);
            } else {
                UIHelper.showValidationError("There are errors in this view. Please fix them first or cancel.");
            }
        }
    }

    private void callAdditionalCallbacksIfThereAreAny(EditControls.ButtonType type, Component outer) {
        if (this.parameter.getAdditionalCallback() == null) {
            return;
        }
        this.parameter.getAdditionalCallback().callback(type, outer);
    }

    protected FormParameter getFormParameter() {
        return this.parameter;
    }
}

