/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Item;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.data.StringRenderer;
import org.opennms.features.jmxconfiggenerator.webui.ui.IconProvider;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansHelper;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

class MBeansItemStrategyHandler {
    private final Map<Class<?>, ItemStrategy> propertyStrategy = new HashMap();
    private final Map<Class<?>, StringRenderer<?>> extractors = new HashMap();

    public MBeansItemStrategyHandler() {
        this.propertyStrategy.put(Map.Entry.class, new EntryItemStrategy());
        this.propertyStrategy.put(Mbean.class, new MBeanItemStrategy());
        this.propertyStrategy.put(String.class, new StringItemStrategy());
        this.extractors.put(String.class, new StringRenderer<String>(){

            @Override
            public String render(String input) {
                return input;
            }
        });
        this.extractors.put(Mbean.class, new StringRenderer<Mbean>(){

            @Override
            public String render(Mbean input) {
                return MBeansHelper.getLeafLabel(input);
            }
        });
        this.extractors.put(Map.Entry.class, new StringRenderer<Map.Entry>(){

            @Override
            public String render(Map.Entry entry) {
                return (String)entry.getValue();
            }
        });
    }

    protected ItemStrategy getStrategy(Class<?> clazz) {
        return MBeansHelper.getValueForClass(this.propertyStrategy, clazz);
    }

    protected StringRenderer getStringRenderer(Class<?> clazz) {
        return MBeansHelper.getValueForClass(this.extractors, clazz);
    }

    protected void setItemProperties(Item item, Object itemId) {
        if (itemId == null || item == null) {
            return;
        }
        this.getStrategy(itemId.getClass()).setItemProperties(item, itemId);
    }

    private static class MBeanItemStrategy
    implements ItemStrategy {
        private MBeanItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            if (!(itemId instanceof Mbean)) {
                return;
            }
            Mbean bean = (Mbean)itemId;
            item.getItemProperty((Object)"icon").setValue((Object)IconProvider.getIcon("crystal_project/blockdevice.png"));
            item.getItemProperty((Object)"name").setValue((Object)bean.getObjectname());
            item.getItemProperty((Object)"editableName").setValue((Object)bean.getName());
            item.getItemProperty((Object)"caption").setValue((Object)bean.getObjectname());
            item.getItemProperty((Object)"label").setValue((Object)MBeansHelper.getLeafLabel(bean));
        }

        @Override
        public Object[] getVisibleColumns() {
            return new Object[]{"selected", "name", "editableName"};
        }

        @Override
        public void handleSelectDeselect(Item item, Object itemId, boolean selected) {
            item.getItemProperty((Object)"selected").setValue((Object)selected);
            this.updateIcon(item, selected);
        }

        private void updateIcon(Item item, boolean selected) {
            item.getItemProperty((Object)"icon").setValue((Object)IconProvider.getMBeansIcon(selected));
        }

        @Override
        public void updateIcon(Item item) {
            this.updateIcon(item, (Boolean)item.getItemProperty((Object)"selected").getValue());
        }

        @Override
        public void updateModel(Item item, Object itemId) {
            if (itemId == null || !(itemId instanceof Mbean)) {
                return;
            }
            Mbean bean = (Mbean)itemId;
            bean.setName((String)item.getItemProperty((Object)"editableName").getValue());
        }
    }

    private static class EntryItemStrategy
    implements ItemStrategy {
        private EntryItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            item.getItemProperty((Object)"icon").setValue((Object)IconProvider.getIcon("crystal_project/folder_blue.png"));
            item.getItemProperty((Object)"label").setValue(((Map.Entry)itemId).getValue());
            item.getItemProperty((Object)"caption").setValue(((Map.Entry)itemId).getValue());
        }

        @Override
        public Object[] getVisibleColumns() {
            return new Object[]{"label"};
        }

        @Override
        public void handleSelectDeselect(Item item, Object itemId, boolean select) {
        }

        @Override
        public void updateIcon(Item item) {
        }

        @Override
        public void updateModel(Item item, Object itemId) {
        }
    }

    private static class StringItemStrategy
    implements ItemStrategy {
        private StringItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            item.getItemProperty((Object)"icon").setValue((Object)IconProvider.getIcon("crystal_project/folder_blue.png"));
            item.getItemProperty((Object)"label").setValue(itemId);
            item.getItemProperty((Object)"caption").setValue(itemId);
        }

        @Override
        public Object[] getVisibleColumns() {
            return new Object[]{"label"};
        }

        @Override
        public void handleSelectDeselect(Item item, Object itemId, boolean select) {
        }

        @Override
        public void updateIcon(Item item) {
        }

        @Override
        public void updateModel(Item item, Object itemId) {
        }
    }

    protected static interface ItemStrategy {
        public void setItemProperties(Item var1, Object var2);

        public Object[] getVisibleColumns();

        public void handleSelectDeselect(Item var1, Object var2, boolean var3);

        public void updateIcon(Item var1);

        public void updateModel(Item var1, Object var2);
    }
}

