/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.AttributesTable;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.EditControls;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.FormParameter;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.NameEditForm;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedListener;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MBeansContentTabSheet
extends TabSheet
implements ModelChangeListener<Mbean>,
ViewStateChangedListener {
    private AttributesLayout attributesLayout;
    private CompositesLayout compositesLayout;
    private final MBeansController controller;
    private int selectedTabPosition;

    public MBeansContentTabSheet(MBeansController controller) {
        this.controller = controller;
        this.setSizeFull();
        this.attributesLayout = new AttributesLayout();
        this.compositesLayout = new CompositesLayout();
        this.attributesLayout.setSizeFull();
        this.compositesLayout.setSizeFull();
        this.addTab((Component)this.attributesLayout, "Attributes");
        this.addTab((Component)this.compositesLayout, "Composites");
    }

    @Override
    public void modelChanged(Mbean newModel) {
        this.attributesLayout.modelChanged(newModel);
        this.compositesLayout.modelChanged(newModel);
        this.disableCompositesTabIfNecessary(newModel);
    }

    @Override
    public void viewStateChanged(ViewStateChangedEvent event) {
        this.attributesLayout.viewStateChanged(event);
        this.compositesLayout.viewStateChanged(event);
        this.selectedTabPosition = UIHelper.enableTabs(this, event, this.selectedTabPosition);
        this.disableCompositesTabIfNecessary(this.controller.getSelectedMBean());
    }

    private void disableCompositesTabIfNecessary(Mbean newModel) {
        boolean alreadyDisabled = !this.getTab((Component)this.compositesLayout).isEnabled();
        boolean shouldDisable = newModel == null || newModel.getCompAttrib().isEmpty();
        boolean disabled = shouldDisable || alreadyDisabled;
        this.getTab((Component)this.compositesLayout).setEnabled(!disabled);
        this.getTab((Component)this.compositesLayout).setDescription(disabled ? "no composites available" : null);
    }

    private class AttributesLayout
    extends VerticalLayout
    implements ViewStateChangedListener,
    EditControls.Callback<Table> {
        private final AttributesTable attributesTable;
        private final EditControls footer;

        private AttributesLayout() {
            this.attributesTable = new AttributesTable(MBeansContentTabSheet.this.controller, new MBeansController.Callback(){

                @Override
                public Container getContainer() {
                    return MBeansContentTabSheet.this.controller.getAttributeContainer(MBeansContentTabSheet.this.controller.getSelectedMBean());
                }
            });
            this.footer = new EditControls(this.attributesTable);
            this.setSizeFull();
            this.addComponent((Component)this.footer);
            this.addComponent((Component)this.attributesTable);
            this.setSpacing(false);
            this.setMargin(false);
            this.addFooterHooks();
            this.setExpandRatio((Component)this.attributesTable, 1.0f);
        }

        @Override
        public void callback(EditControls.ButtonType type, Table outer) {
            if (type == EditControls.ButtonType.cancel) {
                outer.discard();
                MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.LeafSelected, outer);
            }
            if (type == EditControls.ButtonType.edit) {
                MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.Edit, outer);
            }
            if (type == EditControls.ButtonType.save) {
                if (outer.isValid()) {
                    outer.commit();
                    MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.LeafSelected, outer);
                } else {
                    UIHelper.showValidationError("There are errors in this view. Please fix them first or cancel.");
                }
            }
        }

        private void addFooterHooks() {
            this.footer.addSaveHook(this);
            this.footer.addCancelHook(this);
            this.footer.addEditHook(this);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.footer.setVisible(enabled);
        }

        @Override
        public void viewStateChanged(ViewStateChangedEvent event) {
            switch (event.getNewState()) {
                case Init: 
                case NonLeafSelected: 
                case Edit: {
                    this.footer.setVisible(event.getSource() == this.attributesTable);
                    break;
                }
                case LeafSelected: {
                    this.footer.setVisible(true);
                }
            }
            this.attributesTable.viewStateChanged(event);
        }

        private void modelChanged(Mbean newModel) {
            this.attributesTable.modelChanged(newModel);
        }
    }

    private class CompositesLayout
    extends VerticalLayout
    implements ViewStateChangedListener,
    ModelChangeListener<Mbean> {
        private final TabSheet tabSheet = new TabSheet();
        private int selectedCompositesTabPosition;

        public CompositesLayout() {
            this.setSizeFull();
            this.setSpacing(false);
            this.setMargin(false);
            this.tabSheet.setSizeFull();
            this.addComponent((Component)this.tabSheet);
        }

        @Override
        public void viewStateChanged(ViewStateChangedEvent event) {
            this.selectedCompositesTabPosition = UIHelper.enableTabs(this.tabSheet, event, this.selectedCompositesTabPosition);
            if (this.tabSheet.getSelectedTab() == null) {
                return;
            }
            ((CompositeTabLayout)this.tabSheet.getSelectedTab()).viewStateChanged(event);
        }

        @Override
        public void modelChanged(Mbean newModel) {
            this.tabSheet.removeAllComponents();
            int no = 1;
            for (CompAttrib attrib : newModel.getCompAttrib()) {
                String tabLabel = String.format("#%d %s", no++, attrib.getName());
                CompositeTabLayout tabContent = new CompositeTabLayout(this.getCompositeForm(newModel, attrib), this.getCompAttribTable(newModel, attrib));
                this.tabSheet.addTab((Component)tabContent, tabLabel);
            }
        }

        private NameEditForm getCompositeForm(Mbean mbean, CompAttrib compAttrib) {
            NameEditForm form = new NameEditForm(MBeansContentTabSheet.this.controller, new FormParameter(){

                @Override
                public boolean hasFooter() {
                    return false;
                }

                @Override
                public String getCaption() {
                    return null;
                }

                @Override
                public String getEditablePropertyName() {
                    return "name";
                }

                @Override
                public String getNonEditablePropertyName() {
                    return "alias";
                }

                @Override
                public Object[] getVisiblePropertieNames() {
                    return new Object[]{"selected", this.getNonEditablePropertyName(), this.getEditablePropertyName()};
                }

                @Override
                public EditControls.Callback getAdditionalCallback() {
                    return null;
                }
            });
            Item item = MBeansContentTabSheet.this.controller.getCompositeAttributeContainer(mbean).getItem(compAttrib);
            form.setItemDataSource(item);
            return form;
        }

        private Table getCompAttribTable(Mbean mbean, final CompAttrib attrib) {
            AttributesTable memberTable = new AttributesTable(MBeansContentTabSheet.this.controller, new MBeansController.Callback(){

                @Override
                public Container getContainer() {
                    return MBeansContentTabSheet.this.controller.getCompositeMemberContainer(attrib);
                }
            });
            memberTable.modelChanged(mbean);
            return memberTable;
        }

        private class CompositeTabLayout
        extends VerticalLayout
        implements Property.ReadOnlyStatusChangeNotifier,
        EditControls.Callback,
        ViewStateChangedListener {
            private final NameEditForm compositeForm;
            private final Table compositeTable;
            private final EditControls.FormButtonHandler<NameEditForm> formButtonHandler;
            private final EditControls.TableButtonHandler<Table> tableButtonHandler;
            private final EditControls<AbstractField<?>> footer;

            private CompositeTabLayout(NameEditForm compositeForm, Table compositeTable) {
                this.compositeForm = compositeForm;
                this.compositeTable = compositeTable;
                this.formButtonHandler = new EditControls.FormButtonHandler<NameEditForm>(compositeForm);
                this.tableButtonHandler = new EditControls.TableButtonHandler<Table>(compositeTable);
                this.footer = new EditControls(this, new EditControls.ButtonHandler<AbstractField<?>>(){

                    @Override
                    public void handleSave() {
                        if (((NameEditForm)CompositeTabLayout.this.formButtonHandler.getOuter()).isValid() && ((Table)CompositeTabLayout.this.tableButtonHandler.getOuter()).isValid()) {
                            CompositeTabLayout.this.formButtonHandler.handleSave();
                            CompositeTabLayout.this.tableButtonHandler.handleSave();
                        } else {
                            UIHelper.showValidationError("There are some errors on this view. Please fix them first");
                        }
                    }

                    @Override
                    public void handleCancel() {
                        CompositeTabLayout.this.formButtonHandler.handleCancel();
                        CompositeTabLayout.this.tableButtonHandler.handleCancel();
                    }

                    @Override
                    public void handleEdit() {
                        CompositeTabLayout.this.formButtonHandler.handleEdit();
                        CompositeTabLayout.this.tableButtonHandler.handleEdit();
                    }

                    @Override
                    public AbstractField getOuter() {
                        return null;
                    }
                });
                this.setSizeFull();
                this.setSpacing(false);
                this.setReadOnly(true);
                this.addComponent((Component)this.footer);
                this.addComponent((Component)compositeForm);
                this.addComponent((Component)compositeTable);
                this.addFooterHooks(this.footer);
                this.setExpandRatio((Component)compositeTable, 1.0f);
            }

            public void addListener(Property.ReadOnlyStatusChangeListener listener) {
                this.addReadOnlyStatusChangeListener(listener);
            }

            public void addReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
                this.compositeForm.addListener(listener);
                this.compositeTable.addListener(listener);
            }

            public void removeListener(Property.ReadOnlyStatusChangeListener listener) {
                this.removeReadOnlyStatusChangeListener(listener);
            }

            public void removeReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
                this.compositeForm.removeListener(listener);
                this.compositeTable.removeListener(listener);
            }

            public void setReadOnly(boolean readOnly) {
                super.setReadOnly(readOnly);
                this.compositeForm.setReadOnly(readOnly);
                this.compositeTable.setReadOnly(readOnly);
            }

            public void callback(EditControls.ButtonType type, Component outer) {
                if (type == EditControls.ButtonType.edit) {
                    MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.Edit, outer);
                }
                if (type == EditControls.ButtonType.cancel) {
                    MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.LeafSelected, outer);
                }
                if (type == EditControls.ButtonType.save && this.compositeForm.isValid() && this.compositeTable.isValid()) {
                    MBeansContentTabSheet.this.controller.fireViewStateChanged(ViewState.LeafSelected, this);
                }
            }

            private void addFooterHooks(EditControls<?> footer) {
                footer.addSaveHook(this);
                footer.addCancelHook(this);
                footer.addEditHook(this);
            }

            @Override
            public void viewStateChanged(ViewStateChangedEvent event) {
                switch (event.getNewState()) {
                    case Init: 
                    case LeafSelected: {
                        this.setEnabled(true);
                        this.footer.setVisible(true);
                        break;
                    }
                    case NonLeafSelected: 
                    case Edit: {
                        this.setEnabled(event.getSource() == this);
                        this.footer.setVisible(event.getSource() == this);
                    }
                }
            }
        }
    }
}

