/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Buffered;
import com.vaadin.data.Container;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.data.MetaAttribItem;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.NameProvider;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.TableTextFieldWrapper;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.AttributeNameValidator;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.UniqueAttributeNameValidator;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class AttributesTable
extends Table {
    private final Map<Object, Field<String>> fieldsToValidate = new HashMap<Object, Field<String>>();
    private List<Field<?>> fields = new ArrayList();
    private final UniqueAttributeNameValidator uniqueAttributeNameValidator;
    private final MBeansController.Callback callback;

    public AttributesTable(NameProvider provider, MBeansController.Callback callback) {
        this.callback = callback;
        this.uniqueAttributeNameValidator = new UniqueAttributeNameValidator(provider, this.fieldsToValidate);
        this.setSizeFull();
        this.setSelectable(false);
        this.setEditable(false);
        this.setValidationVisible(true);
        this.setReadOnly(true);
        this.setImmediate(true);
        this.setTableFieldFactory(new AttributesTableFieldFactory());
    }

    public void modelChanged(Mbean bean) {
        if (this.getData() == bean) {
            return;
        }
        this.setData(bean);
        this.fieldsToValidate.clear();
        this.fields.clear();
        this.setContainerDataSource(this.callback.getContainer());
        if (this.getContainerDataSource() == MBeansController.AttributesContainerCache.NULL) {
            return;
        }
        this.setVisibleColumns(new Object[]{"selected", "name", "alias", "type"});
    }

    void viewStateChanged(ViewStateChangedEvent event) {
        switch (event.getNewState()) {
            case Init: {
                this.fieldsToValidate.clear();
                this.fields.clear();
            }
            case NonLeafSelected: {
                this.modelChanged(null);
                break;
            }
            case LeafSelected: {
                this.setReadOnly(true);
            }
        }
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        super.commit();
        if (this.isReadOnly()) {
            return;
        }
        for (Field<?> f : this.fields) {
            f.commit();
        }
    }

    public void discard() throws Buffered.SourceException {
        super.discard();
        for (Field<?> f : this.fields) {
            f.discard();
        }
    }

    public void validate() throws Validator.InvalidValueException {
        super.validate();
        Validator.InvalidValueException validationException = null;
        for (Field<String> tf : this.fieldsToValidate.values()) {
            try {
                tf.validate();
            }
            catch (Validator.InvalidValueException ex) {
                validationException = ex;
            }
        }
        if (validationException != null) {
            throw validationException;
        }
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (Validator.InvalidValueException invex) {
            return false;
        }
        return true;
    }

    private class AttributesTableFieldFactory
    implements TableFieldFactory {
        private final Validator nameValidator = new AttributeNameValidator();
        private final Validator lengthValidator = new StringLengthValidator(String.format("Maximal length is %d", 19), Integer.valueOf(0), Integer.valueOf(19), false);

        private AttributesTableFieldFactory() {
        }

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Object field = null;
            if (propertyId.toString().equals("alias")) {
                TableTextFieldWrapper tf = new TableTextFieldWrapper(this.createAlias(itemId));
                AttributesTable.this.fieldsToValidate.put(itemId, tf);
                field = tf;
            }
            if (propertyId.toString().equals("selected")) {
                CheckBox c = new CheckBox();
                c.setBuffered(true);
                field = c;
            }
            if (propertyId.toString().equals("type")) {
                field = this.createType(itemId);
            }
            if (field == null) {
                return null;
            }
            AttributesTable.this.fields.add(field);
            return field;
        }

        private ComboBox createType(Object itemId) {
            ComboBox select = new ComboBox();
            for (MetaAttribItem.AttribType type : MetaAttribItem.AttribType.values()) {
                select.addItem((Object)type.name());
            }
            select.setValue((Object)MetaAttribItem.AttribType.valueOf(itemId).name());
            select.setNullSelectionAllowed(false);
            select.setData(itemId);
            select.setBuffered(true);
            return select;
        }

        private TextField createAlias(Object itemId) {
            TextField tf = new TextField();
            tf.setValidationVisible(true);
            tf.setBuffered(true);
            tf.setImmediate(true);
            tf.setRequired(true);
            tf.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
            tf.setMaxLength(19);
            tf.setRequiredError("You must provide an attribute name.");
            tf.addValidator(this.nameValidator);
            tf.addValidator(this.lengthValidator);
            tf.addValidator((Validator)AttributesTable.this.uniqueAttributeNameValidator);
            tf.setData(itemId);
            return tf;
        }
    }
}

