/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui;

import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opennms.features.jmxconfiggenerator.webui.ui.IconProvider;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UIHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UIHelper.class);

    public static Button createButton(String buttonCaption, String iconName, Button.ClickListener clickListener) {
        Button button = new Button();
        button.setCaption(buttonCaption);
        button.setIcon((Resource)IconProvider.getIcon(iconName));
        if (clickListener != null) {
            button.addListener(clickListener);
        }
        return button;
    }

    public static Button createButton(String buttonCaption, String iconName) {
        return UIHelper.createButton(buttonCaption, iconName, null);
    }

    public static int enableTabs(TabSheet tabSheet, ViewStateChangedEvent event, int oldSelectedTabPosition) {
        boolean editMode = event.getNewState().isEdit();
        boolean enabled = !editMode;
        int newSelectedTabPosition = 0;
        if (editMode) {
            newSelectedTabPosition = UIHelper.getSelectedTabPosition(tabSheet);
        }
        for (int i = 0; i < tabSheet.getComponentCount(); ++i) {
            tabSheet.getTab(i).setEnabled(enabled);
        }
        if (!editMode) {
            tabSheet.setSelectedTab(tabSheet.getTab(oldSelectedTabPosition));
        }
        return editMode ? newSelectedTabPosition : UIHelper.getSelectedTabPosition(tabSheet);
    }

    private static int getSelectedTabPosition(TabSheet tabSheet) {
        if (tabSheet == null) {
            return 0;
        }
        if (tabSheet.getSelectedTab() == null) {
            return 0;
        }
        if (tabSheet.getTab(tabSheet.getSelectedTab()) == null) {
            return 0;
        }
        return tabSheet.getTabPosition(tabSheet.getTab(tabSheet.getSelectedTab()));
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.warn("Error while closing resource '{}'.", (Object)closeable, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadContentFromFile(Class<?> clazz, String resourceName) {
        if (clazz == null || resourceName == null) {
            LOG.warn("loadContentFromFile not invoked, due to null arguments");
            return "";
        }
        InputStream is = clazz.getResourceAsStream(resourceName);
        if (is == null) {
            LOG.warn("Resource '{}' couldn't be loaded from class '{}'", (Object)resourceName, (Object)clazz.getName());
            return "";
        }
        BufferedReader bufferedReader = null;
        StringBuilder result = new StringBuilder(100);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is));
            String eachLine = null;
            while ((eachLine = bufferedReader.readLine()) != null) {
                result.append(eachLine);
                result.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ioEx) {
            try {
                LOG.error("Error while reading resource from '{}'.", (Object)resourceName, (Object)ioEx);
            }
            catch (Throwable throwable) {
                UIHelper.closeSilently(bufferedReader);
                throw throwable;
            }
            UIHelper.closeSilently(bufferedReader);
        }
        UIHelper.closeSilently(bufferedReader);
        return result.toString();
    }

    public static void showValidationError(String errorMessage) {
        Notification.show((String)"Validation Error", (String)(errorMessage != null ? errorMessage : "An unknown error occured."), (Notification.Type)Notification.Type.WARNING_MESSAGE);
    }

    public static class LayoutCreator {
        private Class<?> layoutType = null;
        private List<Component> components = new ArrayList<Component>();
        private boolean spacing = false;

        public LayoutCreator withComponents(Component ... components) {
            this.components.addAll(Arrays.asList(components));
            return this;
        }

        public LayoutCreator setHorizontal() {
            this.layoutType = HorizontalLayout.class;
            return this;
        }

        public LayoutCreator setVertical() {
            this.layoutType = VerticalLayout.class;
            return this;
        }

        public LayoutCreator setForm() {
            this.layoutType = FormLayout.class;
            return this;
        }

        public LayoutCreator withComponent(Component component) {
            this.components.add(component);
            return this;
        }

        public AbstractOrderedLayout toLayout() {
            AbstractOrderedLayout layout = LayoutCreator.createLayout(this.layoutType, this.components);
            layout.setSpacing(this.spacing);
            return layout;
        }

        public LayoutCreator withSpacing() {
            this.spacing = true;
            return this;
        }

        public LayoutCreator withoutSpacing() {
            this.spacing = false;
            return this;
        }

        private static AbstractOrderedLayout createLayout(Class<?> clazz, List<Component> components) {
            try {
                AbstractOrderedLayout layout = (AbstractOrderedLayout)clazz.newInstance();
                for (Component c : components) {
                    layout.addComponent(c);
                }
                return layout;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }
    }
}

