/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui;

import com.vaadin.server.DownloadStream;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.opennms.features.jmxconfiggenerator.webui.JmxConfigGeneratorApplication;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.ButtonPanel;
import org.opennms.features.jmxconfiggenerator.webui.ui.IconProvider;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.UiState;

public class ConfigResultView
extends CustomComponent
implements ModelChangeListener<UiModel>,
Button.ClickListener {
    private static String DOWNLOAD_FILE_NAME = "jmx-config-files.zip";
    private TabSheet tabSheet = new TabSheet();
    private Map<UiModel.OutputDataKey, TabContent> tabContentMap = new HashMap<UiModel.OutputDataKey, TabContent>();
    private final ButtonPanel buttonPanel = new ButtonPanel(this);
    private final JmxConfigGeneratorApplication app;

    public ConfigResultView(JmxConfigGeneratorApplication app) {
        this.app = app;
        this.setSizeFull();
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setSizeFull();
        mainLayout.addComponent((Component)this.tabSheet);
        mainLayout.addComponent((Component)this.buttonPanel);
        this.tabSheet.setSizeFull();
        this.tabContentMap.put(UiModel.OutputDataKey.JmxDataCollectionConfig, new TabContent(UiModel.OutputDataKey.JmxDataCollectionConfig));
        this.tabContentMap.put(UiModel.OutputDataKey.SnmpGraphProperties, new TabContent(UiModel.OutputDataKey.SnmpGraphProperties));
        this.tabContentMap.put(UiModel.OutputDataKey.CollectdConfigSnippet, new TabContent(UiModel.OutputDataKey.CollectdConfigSnippet));
        for (TabContent eachContent : this.tabContentMap.values()) {
            this.tabSheet.addTab((Component)eachContent, eachContent.getCaption());
        }
        this.tabSheet.setSelectedTab(0);
        this.buttonPanel.getNext().setVisible(false);
        this.buttonPanel.getNext().setCaption("download all");
        this.buttonPanel.getNext().setIcon((Resource)IconProvider.getIcon("crystal_project/button_save.png"));
        mainLayout.setExpandRatio((Component)this.tabSheet, 1.0f);
        this.setCompositionRoot((Component)mainLayout);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getSource().equals(this.buttonPanel.getPrevious())) {
            this.app.updateView(UiState.MbeansView);
        }
    }

    private void downloadConfigFile(Button.ClickEvent event) {
        HashMap<String, String> zipContentMap = new HashMap<String, String>();
        for (UiModel.OutputDataKey eachKey : this.tabContentMap.keySet()) {
            zipContentMap.put(eachKey.getDownloadFilename(), this.tabContentMap.get((Object)eachKey).getConfigContent());
            zipContentMap.put(this.flatten(eachKey.getDescriptionFilename()), this.tabContentMap.get((Object)eachKey).getDescriptionText());
        }
    }

    private String flatten(String filename) {
        return new File(filename).getName();
    }

    @Override
    public void modelChanged(UiModel newValue) {
        if (newValue == null) {
            return;
        }
        for (Map.Entry<UiModel.OutputDataKey, String> eachEntry : newValue.getOutputMap().entrySet()) {
            if (this.tabContentMap.get((Object)eachEntry.getKey()) == null) continue;
            this.tabContentMap.get((Object)eachEntry.getKey()).setConfigContent(eachEntry.getValue());
        }
    }

    private static class TabContent
    extends HorizontalSplitPanel {
        private final TextArea configTextArea = new TextArea();
        private final Label descriptionLabel;

        private TabContent(UiModel.OutputDataKey key) {
            this.setSizeFull();
            this.setLocked(false);
            this.setSplitPosition(50.0f, Sizeable.Unit.PERCENTAGE);
            this.configTextArea.setSizeFull();
            this.descriptionLabel = new Label(UIHelper.loadContentFromFile(((Object)((Object)this)).getClass(), key.getDescriptionFilename()), ContentMode.HTML);
            this.addComponent((Component)this.configTextArea);
            this.addComponent((Component)this.descriptionLabel);
            this.setCaption(key.name());
        }

        public String getDescriptionText() {
            return this.descriptionLabel.getValue();
        }

        public void setConfigContent(String newConfigContent) {
            this.configTextArea.setValue(newConfigContent);
        }

        public String getConfigContent() {
            return this.configTextArea.getValue() == null ? "" : (String)this.configTextArea.getValue();
        }
    }

    private static class DownloadResource
    extends StreamResource {
        public DownloadResource(final Map<String, String> zipContentMap, String filename, UI application) {
            super(new StreamResource.StreamSource(){

                public InputStream getStream() {
                    return new ByteArrayInputStream(DownloadResource.getZipByteArray(zipContentMap));
                }
            }, filename);
            this.setMIMEType("application/unknown");
        }

        public DownloadStream getStream() {
            DownloadStream ds = super.getStream();
            ds.setParameter("Content-Disposition", "attachment; filename=\"" + this.getFilename() + "\"");
            return ds;
        }

        private static byte[] getZipByteArray(Map<String, String> zipContentMap) {
            try {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                ZipOutputStream out = new ZipOutputStream(arrayOutputStream);
                for (Map.Entry<String, String> eachEntry : zipContentMap.entrySet()) {
                    out.putNextEntry(new ZipEntry(eachEntry.getKey()));
                    out.write(eachEntry.getValue().getBytes());
                    out.closeEntry();
                }
                out.close();
                arrayOutputStream.close();
                return arrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                return new byte[0];
            }
        }
    }
}

