/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui;

import com.vaadin.annotations.Theme;
import com.vaadin.data.util.BeanItem;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxDatacollectionConfiggenerator;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxHelper;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.jmxconfiggenerator.log.Slf4jLogAdapter;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.ServiceConfig;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.ConfigForm;
import org.opennms.features.jmxconfiggenerator.webui.ui.ConfigResultView;
import org.opennms.features.jmxconfiggenerator.webui.ui.HeaderPanel;
import org.opennms.features.jmxconfiggenerator.webui.ui.IntroductionView;
import org.opennms.features.jmxconfiggenerator.webui.ui.ModelChangeRegistry;
import org.opennms.features.jmxconfiggenerator.webui.ui.ProgressWindow;
import org.opennms.features.jmxconfiggenerator.webui.ui.UiState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansView;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Theme(value="opennms")
public class JmxConfigGeneratorApplication
extends UI
implements ModelChangeListener<UiModel> {
    private static final Logger LOG = LoggerFactory.getLogger(JmxConfigGeneratorApplication.class);
    private HeaderPanel headerPanel;
    private Panel contentPanel;
    private ProgressWindow progressWindow;
    private UiModel model = new UiModel();
    private ModelChangeRegistry modelChangeRegistry = new ModelChangeRegistry();
    private Map<UiState, Component> viewCache = new HashMap<UiState, Component>();

    protected void init(VaadinRequest request) {
        this.initHeaderPanel();
        this.initContentPanel();
        this.initMainWindow();
        this.registerListener(UiModel.class, this);
        this.updateView(UiState.IntroductionView);
    }

    private void initHeaderPanel() {
        this.headerPanel = new HeaderPanel();
        this.registerListener(UiState.class, this.headerPanel);
    }

    private void initContentPanel() {
        this.contentPanel = new Panel();
        this.contentPanel.setContent((Component)new VerticalLayout());
        this.contentPanel.getContent().setSizeFull();
        this.contentPanel.setSizeFull();
    }

    private void initMainWindow() {
        Window window = new Window("JmxConfigGenerator GUI Tool");
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.headerPanel);
        layout.addComponent((Component)this.contentPanel);
        layout.setExpandRatio((Component)this.contentPanel, 1.0f);
        window.setContent((Component)layout);
        window.getContent().setSizeFull();
        window.setSizeFull();
        this.addWindow(window);
    }

    private void setContentPanelComponent(Component c) {
        this.contentPanel.setContent(c);
    }

    public void updateView(UiState uiState) {
        switch (uiState) {
            case IntroductionView: 
            case ServiceConfigurationView: 
            case MbeansView: 
            case ResultView: {
                this.setContentPanelComponent(this.getView(uiState));
                this.notifyObservers(UiModel.class, this.model);
                break;
            }
            case MbeansDetection: {
                this.showProgressWindow(uiState.getDescription() + ".\n\n This may take a while ...");
                new DetectMBeansWorkerThread().start();
                break;
            }
            case ResultConfigGeneration: {
                this.showProgressWindow(uiState.getDescription() + ".\n\n This may take a while ...");
                new CreateOutputWorkerThread().start();
            }
        }
        this.notifyObservers(UiState.class, (Object)uiState);
    }

    private Component createView(UiState uiState, JmxConfigGeneratorApplication app) {
        Button.ClickListener component = null;
        switch (uiState) {
            case IntroductionView: {
                component = new IntroductionView(app);
                break;
            }
            case ServiceConfigurationView: {
                component = new ConfigForm(app);
                this.registerListener(UiModel.class, (ModelChangeListener)component);
                break;
            }
            case MbeansView: {
                component = new MBeansView(app);
                this.registerListener(UiModel.class, (ModelChangeListener)component);
                break;
            }
            case ResultView: {
                component = new ConfigResultView(app);
                this.registerListener(UiModel.class, (ModelChangeListener)component);
            }
        }
        return component;
    }

    private Component getView(UiState uiState) {
        if (this.viewCache.get((Object)uiState) == null) {
            Component component = this.createView(uiState, this);
            if (component == null) {
                return null;
            }
            this.viewCache.put(uiState, component);
        }
        return this.viewCache.get((Object)uiState);
    }

    private ProgressWindow getProgressWindow() {
        if (this.progressWindow == null) {
            this.progressWindow = new ProgressWindow();
        }
        return this.progressWindow;
    }

    public void showProgressWindow(String label) {
        this.getProgressWindow().setLabelText(label);
        this.addWindow(this.getProgressWindow());
    }

    private void registerListener(Class<?> aClass, ModelChangeListener<?> listener) {
        this.modelChangeRegistry.registerListener((Class)aClass, (ModelChangeListener)listener);
    }

    private void notifyObservers(Class<?> aClass, Object object) {
        this.modelChangeRegistry.notifyObservers((Class)aClass, object);
    }

    @Override
    public void modelChanged(UiModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
        }
    }

    private class CreateOutputWorkerThread
    extends Thread {
        private CreateOutputWorkerThread() {
        }

        @Override
        public void run() {
            if (JmxConfigGeneratorApplication.this.model == null) {
                return;
            }
            try {
                GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator((LogAdapter)new Slf4jLogAdapter(GraphConfigGenerator.class));
                Collection reports = new JmxConfigReader((LogAdapter)new Slf4jLogAdapter(JmxConfigReader.class)).generateReportsByJmxDatacollectionConfig(JmxConfigGeneratorApplication.this.model.getOutputConfig());
                JmxConfigGeneratorApplication.this.model.setSnmpGraphProperties(graphConfigGenerator.generateSnmpGraph(reports));
            }
            catch (Exception ex) {
                JmxConfigGeneratorApplication.this.model.setSnmpGraphProperties(ex.getMessage());
                LOG.error("SNMP Graph-Properties couldn't be created.", (Throwable)ex);
            }
            JmxConfigGeneratorApplication.this.model.updateOutput();
            JmxConfigGeneratorApplication.this.updateView(UiState.ResultView);
            JmxConfigGeneratorApplication.this.removeWindow(JmxConfigGeneratorApplication.this.getProgressWindow());
        }
    }

    private class DetectMBeansWorkerThread
    extends Thread {
        private DetectMBeansWorkerThread() {
        }

        @Override
        public void run() {
            try {
                ServiceConfig config = (ServiceConfig)((BeanItem)((ConfigForm)JmxConfigGeneratorApplication.this.getView(UiState.ServiceConfigurationView)).getItemDataSource()).getBean();
                JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator((LogAdapter)new Slf4jLogAdapter(JmxDatacollectionConfiggenerator.class));
                JMXServiceURL jmxServiceURL = JmxHelper.createJmxServiceUrl(null, (String)config.getHost(), (String)config.getPort(), (boolean)config.isJmxmp());
                JMXConnector connector = JmxHelper.createJmxConnector((String)config.getUser(), (String)config.getPassword(), (JMXServiceURL)jmxServiceURL);
                JmxDatacollectionConfig generateJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(connector.getMBeanServerConnection(), "anyservice", Boolean.valueOf(!config.isSkipDefaultVM()), JmxHelper.loadInternalDictionary());
                connector.close();
                JmxConfigGeneratorApplication.this.model.setRawModel(generateJmxConfigModel);
                JmxConfigGeneratorApplication.this.updateView(UiState.MbeansView);
                JmxConfigGeneratorApplication.this.removeWindow(JmxConfigGeneratorApplication.this.getProgressWindow());
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
        }

        private void handleError(Exception ex) {
            Notification.show((String)"Connection error", (String)("An error occured during connection jmx service. Please verify connection settings.<br/><br/>" + ex.getMessage()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            JmxConfigGeneratorApplication.this.removeWindow(JmxConfigGeneratorApplication.this.getProgressWindow());
        }
    }
}

