/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormFieldFactory;
import com.vaadin.ui.Layout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.Starter;
import org.opennms.features.jmxconfiggenerator.webui.JmxConfigGeneratorApplication;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.ButtonPanel;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.UiState;

public class ConfigForm
extends Form
implements ModelChangeListener<UiModel>,
Button.ClickListener {
    private static final long serialVersionUID = -9179098093927051983L;
    private JmxConfigGeneratorApplication app;
    private ButtonPanel buttonPanel = new ButtonPanel(this);

    public ConfigForm(JmxConfigGeneratorApplication app) {
        this.app = app;
        this.setImmediate(true);
        this.setDescription(UIHelper.loadContentFromFile(this.getClass(), "/descriptions/ServiceConfiguration.html"));
        this.setFormFieldFactory((FormFieldFactory)new DefaultFieldFactory(){

            public com.vaadin.ui.Field<?> createField(Item item, Object propertyId, Component uiContext) {
                if ("password".equals(propertyId)) {
                    PasswordField field = new PasswordField();
                    field.setNullRepresentation("");
                    field.setCaption(1.createCaptionByPropertyId((Object)propertyId));
                    return field;
                }
                return super.createField(item, propertyId, uiContext);
            }
        });
        this.setBuffered(false);
        this.setFooter((Layout)this.buttonPanel);
    }

    @Override
    public void modelChanged(UiModel newModel) {
        this.setItemDataSource((Item)new BeanItem((Object)newModel.getServiceConfig()));
        this.setVisibleItemProperties(this.createVisibleItemProperties());
        this.initFields();
        this.updateDescriptions();
        this.updateAuthenticationFields(false);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (this.buttonPanel.getNext().equals(event.getButton())) {
            if (!this.isValid()) {
                UIHelper.showValidationError("There are still errors on this page. You cannot continue. Please check if all required fields have been filled.");
                return;
            }
            this.app.updateView(UiState.MbeansDetection);
        }
        if (this.buttonPanel.getPrevious().equals(event.getButton())) {
            this.app.updateView(UiState.IntroductionView);
        }
    }

    private Object[] createVisibleItemProperties() {
        return new Object[]{"serviceName", "jmxmp", "host", "port", "authenticate", "user", "password", "skipDefaultVM", "runWritableMBeans"};
    }

    private void updateAuthenticationFields(boolean visible) throws Property.ReadOnlyException, Converter.ConversionException {
        this.getField("authenticate").setValue((Object)visible);
        this.getField("user").setVisible(visible);
        this.getField("password").setVisible(visible);
        if (!visible) {
            this.getField("user").setValue(null);
            this.getField("password").setValue(null);
        }
    }

    private void initFields() {
        this.getField("authenticate").addListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                ConfigForm.this.updateAuthenticationFields((Boolean)event.getProperty().getValue());
            }
        });
        ((TextField)this.getField("user")).setNullRepresentation("");
        ((PasswordField)this.getField("password")).setNullRepresentation("");
        TextField serviceNameField = (TextField)this.getField("serviceName");
        serviceNameField.setNullRepresentation("");
        serviceNameField.setRequired(true);
        serviceNameField.setRequiredError("required");
        serviceNameField.addValidator((Validator)new RegexpValidator("^[A-Za-z0-9_-]+$", "You must specify a valid name. Allowed characters: (A-Za-z0-9_-)"));
        TextField hostNameField = (TextField)this.getField("host");
        hostNameField.setRequired(true);
        hostNameField.setRequiredError("required");
        TextField portField = (TextField)this.getField("port");
        portField.setRequired(true);
        portField.setRequiredError("required");
    }

    private void updateDescriptions() {
        Map<String, String> optionDescriptions = this.getOptionDescriptions();
        Starter.class.getAnnotation(Option.class);
        for (Object property : this.getVisibleItemProperties()) {
            String propName = property.toString();
            if (this.getField(propName) != null && optionDescriptions.get(propName) == null) continue;
        }
    }

    private Map<String, String> getOptionDescriptions() {
        HashMap<String, String> optionDescriptions = new HashMap<String, String>();
        for (Field f : Starter.class.getDeclaredFields()) {
            Option ann = f.getAnnotation(Option.class);
            if (ann == null || ann.usage() == null) continue;
            optionDescriptions.put(ann.name().replaceAll("-", ""), ann.usage());
        }
        return optionDescriptions;
    }
}

