/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.google.common.base.Strings;
import com.vaadin.data.Item;
import com.vaadin.data.util.HierarchicalContainer;
import com.vaadin.server.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.features.jmxconfiggenerator.webui.data.StringRenderer;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.TreeNode;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.TreeNodeImpl;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MbeansHierarchicalContainer
extends HierarchicalContainer {
    private final MBeansController controller;
    private TreeNode root = new TreeNodeImpl();
    private Collection<Mbean> mbeans = new ArrayList<Mbean>();

    public MbeansHierarchicalContainer(MBeansController controller) {
        this.controller = controller;
        this.addContainerProperty("icon", Resource.class, null);
        this.addContainerProperty("editableName", String.class, "");
        this.addContainerProperty("caption", String.class, "");
        this.addContainerProperty("selected", Boolean.class, true);
        this.addContainerProperty("name", String.class, "");
        this.addContainerProperty("label", String.class, "");
    }

    public void updateDataSource(UiModel model) {
        this.mbeans.clear();
        this.buildInternalTree(model);
        this.updateContainer();
    }

    private void buildInternalTree(UiModel model) {
        this.root = new TreeNodeImpl();
        for (Mbean bean : this.getMBeans(model)) {
            this.add(bean);
        }
    }

    public Collection<Mbean> getMBeans() {
        return this.mbeans;
    }

    private List<Mbean> getMBeans(UiModel model) {
        return ((JmxCollection)model.getRawModel().getJmxCollection().get(0)).getMbeans().getMbean();
    }

    private void add(Mbean bean) {
        String objectName = bean.getObjectname();
        if (Strings.isNullOrEmpty((String)objectName)) {
            return;
        }
        if (!objectName.contains(":")) {
            return;
        }
        this.addNodes(bean);
        this.mbeans.add(bean);
    }

    private void updateContainer() {
        this.removeAllItems();
        this.updateChildren(this, this.root);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":\n" + this.printInternalTree(this.root, 0);
    }

    private void addNodes(Mbean bean) {
        TreeNode root = this.root;
        for (Object node : MBeansHelper.getMBeansTreeElements(bean)) {
            root = this.addChild(root, node);
        }
        this.addChild(root, bean);
    }

    private String printInternalTree(TreeNode node, int depth) {
        String tabs = "";
        String ret = "";
        for (int i = 0; i < depth; ++i) {
            tabs = tabs + "    ";
        }
        ret = ret + tabs + node.getData() + "\n";
        for (TreeNode n : node.getChildren()) {
            ret = ret + this.printInternalTree(n, depth + 1);
        }
        return ret;
    }

    private TreeNode addChild(TreeNode root, Object childData) {
        TreeNode node = this.findNodeForData(root, childData);
        if (node != null) {
            return node;
        }
        node = new TreeNodeImpl(root, childData);
        root.addChild(node);
        return node;
    }

    private TreeNode findNodeForData(TreeNode root, Object data) {
        if (root == null) {
            return null;
        }
        if (root.getData() != null && root.getData().equals(data)) {
            return root;
        }
        for (TreeNode node : root.getChildren()) {
            if (node.getData() == null || !node.getData().equals(data)) continue;
            return node;
        }
        return null;
    }

    private void addItem(HierarchicalContainer container, TreeNode root, TreeNode child) {
        Item item = container.addItem(child.getData());
        this.controller.setItemProperties(item, child.getData());
        container.setParent(child.getData(), root.getData());
        container.setChildrenAllowed(child.getData(), child.hasChildren());
    }

    private void updateChildren(HierarchicalContainer container, TreeNode root) {
        Collections.sort(root.getChildren(), new TreeNodeComparator());
        for (TreeNode child : root.getChildren()) {
            this.addItem(container, root, child);
            this.updateChildren(container, child);
        }
    }

    private class TreeNodeComparator
    implements Comparator<TreeNode> {
        private TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            String s1 = o1 == null ? "" : this.getStringComparable(o1.getData());
            String s2 = o2 == null ? "" : this.getStringComparable(o2.getData());
            return s1.compareTo(s2);
        }

        private String getStringComparable(Object data) {
            if (data == null) {
                return "";
            }
            StringRenderer renderer = MbeansHierarchicalContainer.this.controller.getStringRenderer(data.getClass());
            return renderer == null ? data.toString() : renderer.render(data);
        }
    }
}

