/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.data;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.opennms.features.jmxconfiggenerator.webui.data.ServiceConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;

public class UiModel {
    private JmxDatacollectionConfig rawModel;
    private ServiceConfig configModel = new ServiceConfig();
    private final Map<OutputDataKey, String> outputMap = new HashMap<OutputDataKey, String>();
    private JmxDatacollectionConfig outputConfig;
    private String snmpGraphProperties;

    public UiModel setRawModel(JmxDatacollectionConfig rawModel) {
        if (!this.isValid(rawModel)) {
            throw new IllegalArgumentException("Model is not valid.");
        }
        this.rawModel = rawModel;
        return this;
    }

    private boolean isValid(JmxDatacollectionConfig rawModel) {
        return !rawModel.getJmxCollection().isEmpty() && rawModel.getJmxCollection().get(0) != null && ((JmxCollection)rawModel.getJmxCollection().get(0)).getMbeans() != null;
    }

    public JmxDatacollectionConfig getRawModel() {
        return this.rawModel;
    }

    public String getServiceName() {
        return this.configModel.getServiceName();
    }

    public void setOutput(OutputDataKey output, String value) {
        this.outputMap.put(output, value);
    }

    public Map<OutputDataKey, String> getOutputMap() {
        return this.outputMap;
    }

    public ServiceConfig getServiceConfig() {
        return this.configModel;
    }

    public void setJmxDataCollectionAccordingToSelection(JmxDatacollectionConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public JmxDatacollectionConfig getOutputConfig() {
        return this.outputConfig;
    }

    public void updateOutput() {
        this.setOutput(OutputDataKey.JmxDataCollectionConfig, UiModel.marshal(this.getOutputConfig()));
        this.setOutput(OutputDataKey.SnmpGraphProperties, this.snmpGraphProperties);
        this.setOutput(OutputDataKey.CollectdConfigSnippet, "TODO");
    }

    public void setSnmpGraphProperties(String generatedSnmpGraphProperties) {
        this.snmpGraphProperties = generatedSnmpGraphProperties;
    }

    public static String marshal(Object anyObject) {
        StringWriter stringWriter = new StringWriter();
        JAXB.marshal((Object)anyObject, (Writer)stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public static enum OutputDataKey {
        JmxDataCollectionConfig,
        SnmpGraphProperties,
        CollectdConfigSnippet;


        public String getDescriptionFilename() {
            return "/descriptions/" + this.name() + ".html";
        }

        public String getDownloadFilename() {
            return this.name() + ".properties";
        }
    }
}

