/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.data;

import com.vaadin.data.Property;
import com.vaadin.data.util.MethodPropertyDescriptor;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.data.util.VaadinPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.data.Selectable;

public class SelectableItem<T>
extends PropertysetItem
implements Selectable {
    private final T bean;

    SelectableItem(T bean, Map<String, VaadinPropertyDescriptor> pdMap) {
        this.bean = bean;
        for (VaadinPropertyDescriptor pd : pdMap.values()) {
            this.addItemProperty(pd.getName(), pd.createProperty(bean));
        }
    }

    public SelectableItem(T bean) {
        this(bean, SelectableItem.getPropertyDescriptors(bean.getClass()));
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.getItemProperty("selected").getValue();
    }

    public T getBean() {
        return this.bean;
    }

    protected static <T> Map<String, VaadinPropertyDescriptor> getPropertyDescriptors(Class<? super T> clazz) {
        HashMap<String, VaadinPropertyDescriptor> mpdMap = new HashMap<String, VaadinPropertyDescriptor>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                MethodPropertyDescriptor mpd = new MethodPropertyDescriptor(pd.getName(), pd.getPropertyType(), pd.getReadMethod(), pd.getWriteMethod());
                mpdMap.put(pd.getName(), (VaadinPropertyDescriptor)mpd);
            }
            mpdMap.put("selected", new VaadinPropertyDescriptor<T>(){

                public String getName() {
                    return "selected";
                }

                public Class<?> getPropertyType() {
                    return Boolean.class;
                }

                public Property createProperty(T value) {
                    return new ObjectProperty((Object)true, Boolean.class, false);
                }
            });
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return mpdMap;
    }
}

