/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.validators;

import com.google.common.collect.HashMultiset;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.ui.Field;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.NameProvider;

public class UniqueAttributeNameValidator
extends AbstractValidator<String> {
    private final NameProvider provider;
    private final Map<Object, Field<String>> textFieldItemMap;

    public UniqueAttributeNameValidator(NameProvider provider, Map<Object, Field<String>> fieldsForIsValid) {
        super("The attribute name must be unique in whole collection!");
        this.provider = provider;
        this.textFieldItemMap = fieldsForIsValid;
    }

    protected boolean isValidValue(String value) {
        if (value == null || !(value instanceof String)) {
            return false;
        }
        String alias = value;
        HashMultiset nameMultiSet = HashMultiset.create();
        for (Map.Entry<Object, String> entry : this.provider.getNames().entrySet()) {
            Object itemId = entry.getKey();
            String name = entry.getValue();
            nameMultiSet.add((Object)(this.textFieldItemMap.get(itemId) == null ? name : (String)this.textFieldItemMap.get(itemId).getValue()));
        }
        return nameMultiSet.count((Object)alias) <= 1;
    }

    public Class<String> getType() {
        return String.class;
    }
}

