/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opennms.features.jmxconfiggenerator.webui.data.Reflections;
import org.opennms.features.jmxconfiggenerator.webui.data.SimpleEntry;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MBeansHelper {
    public static List getMBeansTreeElements(Mbean input) {
        return MBeansHelper.getMBeansTreeElements(input, true);
    }

    public static String getLeafLabel(Mbean input) {
        List labels = MBeansHelper.getMBeansTreeElements(input, false);
        if (labels.isEmpty()) {
            return input.getName();
        }
        Object label = labels.get(labels.size() - 1);
        if (label instanceof Map.Entry) {
            return ((Map.Entry)label).getValue().toString();
        }
        return label.toString();
    }

    private static List getMBeansTreeElements(Mbean input, boolean removeLastElement) {
        ArrayList<Map.Entry<String, String>> names = new ArrayList<Map.Entry<String, String>>();
        try {
            ObjectName obj = ObjectName.getInstance(input.getObjectname());
            names.add((Map.Entry<String, String>)((Object)obj.getDomain()));
            Hashtable<String, String> keyProperty = obj.getKeyPropertyList();
            MBeansHelper.addIfNotNull(names, keyProperty, "type");
            MBeansHelper.addIfNotNull(names, keyProperty, "j2eeType");
            names.addAll(keyProperty.entrySet());
            if (removeLastElement) {
                names.remove(names.size() - 1);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return names;
    }

    private static void addIfNotNull(List<Map.Entry<String, String>> names, Map<String, String> keyProperty, String key) {
        if (keyProperty.get(key) == null) {
            return;
        }
        names.add(new SimpleEntry<String>(key, keyProperty.get(key)));
        keyProperty.remove(key);
    }

    public static <T> T getValueForClass(Map<Class<?>, T> map, Class<?> clazz) {
        List<Class<?>> classes = Reflections.buildClassHierarchy(clazz);
        for (int i = classes.size() - 1; i >= 0; --i) {
            if (map.get(classes.get(i)) == null) continue;
            return map.get(classes.get(i));
        }
        return null;
    }
}

