/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opennms.features.jmxconfiggenerator.webui.JmxConfigGeneratorApplication;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.ButtonPanel;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;
import org.opennms.features.jmxconfiggenerator.webui.ui.UiState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.EditControls;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.FormParameter;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansContentTabSheet;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansTree;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.NameEditForm;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedListener;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.AttributeNameValidator;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.NameValidator;
import org.opennms.features.jmxconfiggenerator.webui.ui.validators.UniqueAttributeNameValidator;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MBeansView
extends VerticalLayout
implements Button.ClickListener,
ModelChangeListener,
ViewStateChangedListener {
    private final MBeansController controller = new MBeansController();
    private UiModel model;
    private final JmxConfigGeneratorApplication app;
    private final MBeansTree mbeansTree;
    private final MBeansContentTabSheet mbeansTabSheet;
    private final ButtonPanel buttonPanel = new ButtonPanel(this);
    private final NameEditForm mbeansForm = new NameEditForm(this.controller, new FormParameter(){

        @Override
        public boolean hasFooter() {
            return true;
        }

        @Override
        public String getCaption() {
            return "MBeans details";
        }

        @Override
        public String getEditablePropertyName() {
            return "editableName";
        }

        @Override
        public String getNonEditablePropertyName() {
            return "name";
        }

        @Override
        public Object[] getVisiblePropertieNames() {
            return new Object[]{"selected", "name", "editableName"};
        }

        @Override
        public EditControls.Callback getAdditionalCallback() {
            return new EditControls.Callback<Form>(){

                @Override
                public void callback(EditControls.ButtonType type, Form outer) {
                    if (type == EditControls.ButtonType.save && outer.isValid()) {
                        MBeansView.this.controller.updateMBeanIcon();
                        MBeansView.this.controller.updateMBean();
                    }
                }
            };
        }
    });

    public MBeansView(JmxConfigGeneratorApplication app) {
        this.app = app;
        this.setSizeFull();
        this.mbeansTabSheet = new MBeansContentTabSheet(this.controller);
        this.mbeansTree = new MBeansTree(this.controller);
        Layout mbeansContent = this.initContentPanel(this.mbeansForm, this.mbeansTabSheet);
        AbstractSplitPanel mainPanel = this.initMainPanel((Component)this.mbeansTree, (Component)mbeansContent);
        this.registerListener(this.controller);
        this.addComponent((Component)mainPanel);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)mainPanel, 1.0f);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton().equals(this.buttonPanel.getPrevious())) {
            this.app.updateView(UiState.ServiceConfigurationView);
        }
        if (event.getButton().equals(this.buttonPanel.getNext())) {
            if (!this.isValid()) {
                UIHelper.showValidationError("There are errors on this view. Please fix them first");
                return;
            }
            this.model.setJmxDataCollectionAccordingToSelection(this.controller.createJmxDataCollectionAccordingToSelection(this.model));
            this.app.updateView(UiState.ResultConfigGeneration);
        }
    }

    private AbstractSplitPanel initMainPanel(Component first, Component second) {
        HorizontalSplitPanel layout = new HorizontalSplitPanel();
        layout.setSizeFull();
        layout.setLocked(false);
        layout.setSplitPosition(20.0f, UNITS_PERCENTAGE);
        layout.setFirstComponent(first);
        layout.setSecondComponent(second);
        layout.setCaption(first.getCaption());
        return layout;
    }

    private Layout initContentPanel(NameEditForm form, MBeansContentTabSheet tabSheet) {
        VerticalLayout layout = new VerticalLayout();
        layout.setSizeFull();
        layout.setSpacing(false);
        layout.addComponent((Component)form);
        layout.addComponent((Component)tabSheet);
        layout.setExpandRatio((Component)tabSheet, 1.0f);
        return layout;
    }

    public void modelChanged(Object newModel) {
        if (newModel instanceof UiModel) {
            this.model = (UiModel)newModel;
            this.controller.notifyObservers((Class)UiModel.class, newModel);
        }
    }

    private Panel wrapToPanel(Component component) {
        Panel panel = new Panel(component.getCaption());
        panel.setSizeFull();
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(false);
        layout.setSpacing(false);
        layout.setSizeFull();
        layout.addComponent(component);
        panel.setContent((Component)layout);
        component.setCaption(null);
        return panel;
    }

    private void registerListener(MBeansController controller) {
        controller.registerListener((Class)Item.class, (ModelChangeListener)this.mbeansForm);
        controller.registerListener((Class)Mbean.class, (ModelChangeListener)this.mbeansTabSheet);
        controller.registerListener((Class)UiModel.class, (ModelChangeListener)this.mbeansTree);
        controller.registerListener((Class)UiModel.class, (ModelChangeListener)controller);
        controller.addView(this.mbeansForm);
        controller.addView(this.mbeansTabSheet);
        controller.addView(this.mbeansTree);
        controller.addView(this);
    }

    private boolean isValid() {
        ArrayList<Validator.InvalidValueException> exceptionList = new ArrayList<Validator.InvalidValueException>();
        NameValidator nameValidator = new NameValidator();
        AttributeNameValidator attributeNameValidator = new AttributeNameValidator();
        StringLengthValidator attributeLengthValidator = new StringLengthValidator(String.format("Maximal length is %d", 19), Integer.valueOf(0), Integer.valueOf(19), false);
        UniqueAttributeNameValidator attributeUniqueNameValidator = new UniqueAttributeNameValidator(this.controller, new HashMap<Object, Field<String>>());
        for (Mbean eachMBean : this.controller.getSelectedMbeans()) {
            MBeansView.validate((Validator)nameValidator, eachMBean.getName(), exceptionList);
            for (CompAttrib eachCompositeAttribute : this.controller.getSelectedCompositeAttributes(eachMBean)) {
                MBeansView.validate((Validator)nameValidator, eachCompositeAttribute.getName(), exceptionList);
                for (CompMember eachCompMember : this.controller.getSelectedCompositeMembers(eachCompositeAttribute)) {
                    MBeansView.validate((Validator)attributeNameValidator, eachCompMember.getAlias(), exceptionList);
                    MBeansView.validate((Validator)attributeLengthValidator, eachCompMember.getAlias(), exceptionList);
                    MBeansView.validate((Validator)attributeUniqueNameValidator, eachCompMember.getAlias(), exceptionList);
                }
            }
            for (Attrib eachAttribute : this.controller.getSelectedAttributes(eachMBean)) {
                MBeansView.validate((Validator)attributeNameValidator, eachAttribute.getAlias(), exceptionList);
                MBeansView.validate((Validator)attributeLengthValidator, eachAttribute.getAlias(), exceptionList);
                MBeansView.validate((Validator)attributeUniqueNameValidator, eachAttribute.getAlias(), exceptionList);
            }
        }
        return exceptionList.isEmpty();
    }

    @Override
    public void viewStateChanged(ViewStateChangedEvent event) {
        this.buttonPanel.getPrevious().setEnabled(event.getNewState() != ViewState.Edit);
        this.buttonPanel.getNext().setEnabled(event.getNewState() != ViewState.Edit);
    }

    private static void validate(Validator validator, Object value, List<Validator.InvalidValueException> exceptionList) {
        try {
            validator.validate(value);
        }
        catch (Validator.InvalidValueException ex) {
            exceptionList.add(ex);
        }
    }
}

