/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Container;
import com.vaadin.event.Action;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansController;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MbeansHierarchicalContainer;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedListener;

class MBeansTree
extends Tree
implements ModelChangeListener<UiModel>,
ViewStateChangedListener,
Action.Handler {
    private final MBeansController controller;
    private final MbeansHierarchicalContainer container;
    private final Action SELECT = new Action("select");
    private final Action DESELECT = new Action("deselect");
    private final Action[] ACTIONS = new Action[]{this.SELECT, this.DESELECT};

    protected MBeansTree(final MBeansController controller) {
        this.container = controller.getMBeansHierarchicalContainer();
        this.controller = controller;
        this.setSizeFull();
        this.setCaption("MBeans");
        this.setContainerDataSource((Container)this.container);
        this.setItemCaptionPropertyId("label");
        this.setItemIconPropertyId("icon");
        this.setItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){

            public String generateDescription(Component source, Object itemId, Object propertyId) {
                return MBeansTree.this.getItem(itemId).getItemProperty((Object)"caption").getValue().toString();
            }
        });
        this.setSelectable(true);
        this.setMultiSelect(false);
        this.setNullSelectionAllowed(true);
        this.setMultiselectMode(MultiSelectMode.SIMPLE);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                controller.updateView(event);
            }
        });
        this.setImmediate(true);
        this.addActionHandler(this);
    }

    private Object expandTree() {
        Object firstItemId = null;
        for (Object itemId : this.getItemIds()) {
            if (firstItemId == null) {
                firstItemId = itemId;
            }
            this.expandItem(itemId);
        }
        return firstItemId;
    }

    @Override
    public void modelChanged(UiModel internalModel) {
        this.container.updateDataSource(internalModel);
        Object selectItemId = this.expandTree();
        if (selectItemId != null) {
            this.select(selectItemId);
        } else {
            this.select(this.getNullSelectionItemId());
        }
    }

    @Override
    public void viewStateChanged(ViewStateChangedEvent event) {
        switch (event.getNewState()) {
            case Edit: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(true);
            }
        }
    }

    public Action[] getActions(Object target, Object sender) {
        return this.ACTIONS;
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (action == this.SELECT) {
            this.controller.handleSelect(this.container, target);
        }
        if (action == this.DESELECT) {
            this.controller.handleDeselect(this.container, target);
        }
        this.fireValueChange(false);
    }
}

